/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.commons.jcs.access.CacheAccess;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.mapillary.MapillaryDataListener;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryDownloadAction;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryDownloadViewAction;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryExportAction;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryImportAction;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryImportIntoSequenceAction;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryJoinAction;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryUploadAction;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryWalkAction;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryZoomAction;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryFilterDialog;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryHistoryDialog;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryMainDialog;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryPreferenceSetting;
import org.openstreetmap.josm.plugins.mapillary.io.download.MapillaryDownloader;
import org.openstreetmap.josm.plugins.mapillary.oauth.MapillaryUser;
import org.openstreetmap.josm.tools.ImageProvider;

public class MapillaryPlugin
extends Plugin {
    public static final String CLIENT_ID = "T1Fzd20xZjdtR0s1VDk5OFNIOXpYdzoxNDYyOGRkYzUyYTFiMzgz";
    public static final String SEPARATOR = System.getProperty("file.separator");
    public static final ImageIcon ICON24 = new ImageProvider("icon24.png").get();
    public static final ImageIcon ICON16 = new ImageProvider("icon16.png").get();
    public static final ImageIcon MAP_ICON = new ImageProvider("mapicon.png").get();
    public static final ImageIcon MAP_ICON_SELECTED = new ImageProvider("mapiconselected.png").get();
    public static final ImageIcon MAP_ICON_IMPORTED = new ImageProvider("mapiconimported.png").get();
    public static final ImageIcon MAP_SIGN = new ImageProvider("sign.png").get();
    public static CacheAccess<String, BufferedImageCacheEntry> CACHE;
    private final MapillaryDownloadAction downloadAction = new MapillaryDownloadAction();
    private final MapillaryExportAction exportAction;
    private final MapillaryImportAction importAction;
    private static MapillaryZoomAction zoomAction;
    private final MapillaryDownloadViewAction downloadViewAction;
    private final MapillaryImportIntoSequenceAction importIntoSequenceAction;
    private final MapillaryJoinAction joinAction;
    private static MapillaryWalkAction walkAction;
    private static MapillaryUploadAction uploadAction;
    private JMenuItem downloadMenu;
    private static JMenuItem exportMenu;
    private JMenuItem importMenu;
    private static JMenuItem zoomMenu;
    private static JMenuItem downloadViewMenu;
    private JMenuItem importIntoSequenceMenu;
    private static JMenuItem joinMenu;
    private static JMenuItem walkMenu;
    private static JMenuItem uploadMenu;

    public MapillaryPlugin(PluginInformation info) {
        super(info);
        walkAction = new MapillaryWalkAction();
        this.exportAction = new MapillaryExportAction();
        this.importAction = new MapillaryImportAction();
        zoomAction = new MapillaryZoomAction();
        this.downloadViewAction = new MapillaryDownloadViewAction();
        this.importIntoSequenceAction = new MapillaryImportIntoSequenceAction();
        this.joinAction = new MapillaryJoinAction();
        uploadAction = new MapillaryUploadAction();
        if (Main.main != null) {
            this.downloadMenu = MainMenu.add((JMenu)Main.main.menu.imageryMenu, (JosmAction)this.downloadAction, (boolean)false);
            exportMenu = MainMenu.add((JMenu)Main.main.menu.fileMenu, (JosmAction)this.exportAction, (boolean)false, (Integer)14);
            this.importIntoSequenceMenu = MainMenu.add((JMenu)Main.main.menu.fileMenu, (JosmAction)this.importIntoSequenceAction, (boolean)false, (Integer)14);
            this.importMenu = MainMenu.add((JMenu)Main.main.menu.fileMenu, (JosmAction)this.importAction, (boolean)false, (Integer)14);
            uploadMenu = MainMenu.add((JMenu)Main.main.menu.fileMenu, (JosmAction)uploadAction, (boolean)false, (Integer)14);
            zoomMenu = MainMenu.add((JMenu)Main.main.menu.viewMenu, (JosmAction)zoomAction, (boolean)false, (Integer)15);
            downloadViewMenu = MainMenu.add((JMenu)Main.main.menu.fileMenu, (JosmAction)this.downloadViewAction, (boolean)false, (Integer)14);
            joinMenu = MainMenu.add((JMenu)Main.main.menu.dataMenu, (JosmAction)this.joinAction, (boolean)false);
            walkMenu = MainMenu.add((JMenu)Main.main.menu.moreToolsMenu, (JosmAction)walkAction, (boolean)false);
            exportMenu.setEnabled(false);
            this.downloadMenu.setEnabled(false);
            this.importMenu.setEnabled(false);
            this.importIntoSequenceMenu.setEnabled(false);
            zoomMenu.setEnabled(false);
            downloadViewMenu.setEnabled(false);
            joinMenu.setEnabled(false);
            walkMenu.setEnabled(false);
        }
        try {
            CACHE = JCSCacheManager.getCache((String)"mapillary", (int)10, (int)10000, (String)(this.getPluginDir() + "/cache/"));
        }
        catch (IOException e) {
            Main.error((Throwable)e);
        }
        if (Main.pref.get("mapillary.access-token") == null) {
            MapillaryUser.isTokenValid = false;
        }
    }

    public static JMenuItem getDownloadViewMenu() {
        return downloadViewMenu;
    }

    public static JMenuItem getExportMenu() {
        return exportMenu;
    }

    public static JMenuItem getJoinMenu() {
        return joinMenu;
    }

    public static MapillaryDataListener getUploadAction() {
        return uploadAction;
    }

    public static JMenuItem getUploadMenu() {
        return uploadMenu;
    }

    public static MapillaryWalkAction getWalkAction() {
        return walkAction;
    }

    public static JMenuItem getWalkMenu() {
        return walkMenu;
    }

    public static MapillaryDataListener getZoomAction() {
        return zoomAction;
    }

    public static JMenuItem getZoomMenu() {
        return zoomMenu;
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame == null && newFrame != null) {
            Main.map.addToggleDialog((ToggleDialog)MapillaryMainDialog.getInstance(), false);
            Main.map.addToggleDialog((ToggleDialog)MapillaryHistoryDialog.getInstance(), false);
            Main.map.addToggleDialog((ToggleDialog)MapillaryFilterDialog.getInstance(), false);
            MapillaryPlugin.setMenuEnabled(this.downloadMenu, true);
            if (MapillaryDownloader.getMode() == MapillaryDownloader.MODES.Manual) {
                MapillaryPlugin.setMenuEnabled(downloadViewMenu, true);
            }
            MapillaryPlugin.setMenuEnabled(this.importMenu, true);
            MapillaryPlugin.setMenuEnabled(this.importIntoSequenceMenu, true);
        }
        if (oldFrame != null && newFrame == null) {
            MapillaryMainDialog.destroyInstance();
            MapillaryHistoryDialog.destroyInstance();
            MapillaryFilterDialog.destroyInstance();
            MapillaryPlugin.setMenuEnabled(this.downloadMenu, false);
            MapillaryPlugin.setMenuEnabled(downloadViewMenu, false);
            MapillaryPlugin.setMenuEnabled(this.importMenu, false);
            MapillaryPlugin.setMenuEnabled(this.importIntoSequenceMenu, false);
        }
    }

    public static void setMenuEnabled(final JMenuItem menu, final boolean value) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapillaryPlugin.setMenuEnabled(menu, value);
                }
            });
        } else {
            menu.setEnabled(value);
            menu.getAction().setEnabled(value);
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new MapillaryPreferenceSetting();
    }

    public static ImageProvider getProvider(String s) {
        if (Main.main == null) {
            return null;
        }
        return new ImageProvider(s);
    }
}

