/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class SimplifyBooleanReturnCheck
extends Check {
    public static final String MSG_KEY = "simplify.boolReturn";

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{83};
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST elseLiteral = ast.findFirstToken(92);
        if (elseLiteral == null) {
            return;
        }
        AST elseStatement = elseLiteral.getFirstChild();
        DetailAST condition = ast.getFirstChild().getNextSibling();
        AST thenStatement = condition.getNextSibling().getNextSibling();
        if (SimplifyBooleanReturnCheck.canReturnOnlyBooleanLiteral(thenStatement) && SimplifyBooleanReturnCheck.canReturnOnlyBooleanLiteral(elseStatement)) {
            this.log(ast.getLineNo(), ast.getColumnNo(), MSG_KEY, new Object[0]);
        }
    }

    private static boolean canReturnOnlyBooleanLiteral(AST ast) {
        if (SimplifyBooleanReturnCheck.isBooleanLiteralReturnStatement(ast)) {
            return true;
        }
        AST firstStatement = ast.getFirstChild();
        return SimplifyBooleanReturnCheck.isBooleanLiteralReturnStatement(firstStatement);
    }

    private static boolean isBooleanLiteralReturnStatement(AST ast) {
        AST expr;
        boolean booleanReturnStatement = false;
        if (ast != null && ast.getType() == 88 && (expr = ast.getFirstChild()).getType() != 45) {
            AST value = expr.getFirstChild();
            booleanReturnStatement = SimplifyBooleanReturnCheck.isBooleanLiteralType(value.getType());
        }
        return booleanReturnStatement;
    }

    private static boolean isBooleanLiteralType(int tokenType) {
        boolean isTrue = tokenType == 133;
        boolean isFalse = tokenType == 134;
        return isTrue || isFalse;
    }
}

