/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class RequireThisCheck
extends Check {
    public static final String MSG_METHOD = "require.this.method";
    public static final String MSG_VARIABLE = "require.this.variable";
    private static final ImmutableSet<Integer> DECLARATION_TOKENS = ImmutableSet.of(Integer.valueOf(10), Integer.valueOf(8), Integer.valueOf(9), Integer.valueOf(14), Integer.valueOf(154), Integer.valueOf(15), new Integer[]{21, 164});
    private Map<DetailAST, LexicalFrame> frames;
    private LexicalFrame current;
    private boolean checkFields = true;
    private boolean checkMethods = true;

    public void setCheckFields(boolean checkFields) {
        this.checkFields = checkFields;
    }

    public void setCheckMethods(boolean checkMethods) {
        this.checkMethods = checkMethods;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{14, 15, 154, 8, 9, 7, 58};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        LinkedList<LexicalFrame> frameStack = Lists.newLinkedList();
        frameStack.add(new GlobalFrame());
        this.frames = Maps.newHashMap();
        DetailAST curNode = rootAST;
        while (curNode != null) {
            RequireThisCheck.collectDeclarations(frameStack, curNode);
            DetailAST toVisit = curNode.getFirstChild();
            while (curNode != null && toVisit == null) {
                this.endCollectingDeclarations(frameStack, curNode);
                toVisit = curNode.getNextSibling();
                if (toVisit != null) continue;
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 58: {
                this.processIdent(ast);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                this.current = this.frames.get(ast);
                break;
            }
        }
    }

    private void processIdent(DetailAST ast) {
        int parentType = ast.getParent().getType();
        switch (parentType) {
            case 159: 
            case 160: 
            case 161: {
                break;
            }
            case 27: {
                if (!this.checkMethods || !this.isClassMethod(ast)) break;
                this.log(ast, MSG_METHOD, ast.getText());
                break;
            }
            default: {
                if (!this.checkFields) break;
                this.processField(ast, parentType);
            }
        }
    }

    private void processField(DetailAST ast, int parentType) {
        boolean typeName;
        boolean importOrPackage = ScopeUtils.getSurroundingScope(ast) == null;
        boolean methodNameInMethodCall = parentType == 59 && ast.getPreviousSibling() != null;
        boolean bl = typeName = parentType == 13 || parentType == 136;
        if (!(importOrPackage || methodNameInMethodCall || typeName || RequireThisCheck.isDeclarationToken(parentType) || !this.isClassField(ast))) {
            this.log(ast, MSG_VARIABLE, ast.getText());
        }
    }

    private static void collectDeclarations(Deque<LexicalFrame> frameStack, DetailAST ast) {
        LexicalFrame frame = frameStack.peek();
        switch (ast.getType()) {
            case 10: {
                RequireThisCheck.collectVariableDeclarations(ast, frame);
                break;
            }
            case 21: {
                DetailAST parameterIdent = ast.findFirstToken(58);
                frame.addIdent(parameterIdent);
                break;
            }
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                DetailAST classIdent = ast.findFirstToken(58);
                frame.addIdent(classIdent);
                frameStack.addFirst(new ClassFrame(frame));
                break;
            }
            case 7: {
                frameStack.addFirst(new BlockFrame(frame));
                break;
            }
            case 9: {
                DetailAST ident = ast.findFirstToken(58);
                if (frame instanceof ClassFrame) {
                    DetailAST mods = ast.findFirstToken(5);
                    if (mods.branchContains(64)) {
                        ((ClassFrame)frame).addStaticMethod(ident);
                    } else {
                        ((ClassFrame)frame).addInstanceMethod(ident);
                    }
                }
                frameStack.addFirst(new MethodFrame(frame));
                break;
            }
            case 8: {
                frameStack.addFirst(new MethodFrame(frame));
                break;
            }
        }
    }

    private static void collectVariableDeclarations(DetailAST ast, LexicalFrame frame) {
        DetailAST ident = ast.findFirstToken(58);
        if (frame instanceof ClassFrame) {
            DetailAST mods = ast.findFirstToken(5);
            if (ScopeUtils.isInInterfaceBlock(ast) || mods.branchContains(64)) {
                ((ClassFrame)frame).addStaticMember(ident);
            } else {
                ((ClassFrame)frame).addInstanceMember(ident);
            }
        } else {
            frame.addIdent(ident);
        }
    }

    private void endCollectingDeclarations(Queue<LexicalFrame> frameStack, DetailAST ast) {
        switch (ast.getType()) {
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                this.frames.put(ast, frameStack.poll());
                break;
            }
        }
    }

    private boolean isClassField(DetailAST ident) {
        LexicalFrame frame = this.findFrame(ident, false);
        return frame instanceof ClassFrame && ((ClassFrame)frame).hasInstanceMember(ident);
    }

    private boolean isClassMethod(DetailAST ident) {
        LexicalFrame frame = this.findFrame(ident, true);
        return frame instanceof ClassFrame && ((ClassFrame)frame).hasInstanceMethod(ident);
    }

    private LexicalFrame findFrame(DetailAST name, boolean lookForMethod) {
        if (this.current == null) {
            return null;
        }
        return this.current.getIfContains(name, lookForMethod);
    }

    private static boolean isDeclarationToken(int parentType) {
        return DECLARATION_TOKENS.contains(parentType);
    }

    private static class BlockFrame
    extends LexicalFrame {
        protected BlockFrame(LexicalFrame parent) {
            super(parent);
        }
    }

    private static class ClassFrame
    extends LexicalFrame {
        private final Set<DetailAST> instanceMembers = Sets.newHashSet();
        private final Set<DetailAST> instanceMethods = Sets.newHashSet();
        private final Set<DetailAST> staticMembers = Sets.newHashSet();
        private final Set<DetailAST> staticMethods = Sets.newHashSet();

        ClassFrame(LexicalFrame parent) {
            super(parent);
        }

        public void addStaticMember(DetailAST ident) {
            this.staticMembers.add(ident);
        }

        public void addStaticMethod(DetailAST ident) {
            this.staticMethods.add(ident);
        }

        public void addInstanceMember(DetailAST ident) {
            this.instanceMembers.add(ident);
        }

        public void addInstanceMethod(DetailAST ident) {
            this.instanceMethods.add(ident);
        }

        public boolean hasInstanceMember(DetailAST ident) {
            return this.containsName(this.instanceMembers, ident);
        }

        public boolean hasInstanceMethod(DetailAST ident) {
            return this.containsName(this.instanceMethods, ident);
        }

        @Override
        boolean contains(DetailAST nameToFind) {
            return super.contains(nameToFind) || this.containsName(this.instanceMembers, nameToFind) || this.containsName(this.instanceMethods, nameToFind) || this.containsName(this.staticMembers, nameToFind) || this.containsName(this.staticMethods, nameToFind);
        }

        @Override
        protected boolean isProperDefinition(DetailAST ident, DetailAST ast) {
            String nameToFind = ident.getText();
            return nameToFind.equals(ast.getText());
        }

        @Override
        protected LexicalFrame getIfContains(DetailAST nameToFind, boolean lookForMethod) {
            LexicalFrame frame = this.contains(nameToFind) ? this : this.getParent().getIfContains(nameToFind, lookForMethod);
            return frame;
        }
    }

    private static class MethodFrame
    extends LexicalFrame {
        protected MethodFrame(LexicalFrame parent) {
            super(parent);
        }
    }

    private static class GlobalFrame
    extends LexicalFrame {
        protected GlobalFrame() {
            super(null);
        }
    }

    private static class LexicalFrame {
        private final Set<DetailAST> varIdents;
        private final LexicalFrame parent;

        protected LexicalFrame(LexicalFrame parent) {
            this.parent = parent;
            this.varIdents = Sets.newHashSet();
        }

        private void addIdent(DetailAST identToAdd) {
            this.varIdents.add(identToAdd);
        }

        protected LexicalFrame getParent() {
            return this.parent;
        }

        boolean contains(DetailAST nameToFind) {
            return this.containsName(this.varIdents, nameToFind);
        }

        protected LexicalFrame getIfContains(DetailAST nameToFind, boolean lookForMethod) {
            LexicalFrame frame = null;
            if (!lookForMethod && this.contains(nameToFind)) {
                frame = this;
            } else if (this.parent != null) {
                frame = this.parent.getIfContains(nameToFind, lookForMethod);
            }
            return frame;
        }

        protected boolean containsName(Set<DetailAST> set, DetailAST ident) {
            boolean result = false;
            for (DetailAST ast : set) {
                if (!this.isProperDefinition(ident, ast)) continue;
                result = true;
                break;
            }
            return result;
        }

        protected boolean isProperDefinition(DetailAST ident, DetailAST ast) {
            String nameToFind = ident.getText();
            return nameToFind.equals(ast.getText()) && LexicalFrame.checkPosition(ast, ident);
        }

        private static boolean checkPosition(DetailAST ast1, DetailAST ast2) {
            boolean result = false;
            if (ast1.getLineNo() < ast2.getLineNo() || ast1.getLineNo() == ast2.getLineNo() && ast1.getColumnNo() < ast2.getColumnNo()) {
                result = true;
            }
            return result;
        }
    }
}

