/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ResourceBundle;
import org.apache.commons.lang3.ArrayUtils;

public final class TokenUtils {
    private static final ImmutableMap<String, Integer> TOKEN_NAME_TO_VALUE;
    private static final String[] TOKEN_VALUE_TO_NAME;
    private static final int[] TOKEN_IDS;
    private static final String TOKEN_ID_EXCEPTION_PREFIX = "given id ";
    private static final String TOKEN_NAME_EXCEPTION_PREFIX = "given name ";

    private TokenUtils() {
    }

    public static int getIntFromField(Field field, Object object) {
        try {
            return field.getInt(object);
        }
        catch (IllegalAccessException exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static int[] getAllTokenIds() {
        int[] safeCopy = new int[TOKEN_IDS.length];
        System.arraycopy(TOKEN_IDS, 0, safeCopy, 0, TOKEN_IDS.length);
        return safeCopy;
    }

    public static String getTokenName(int id) {
        if (id > TOKEN_VALUE_TO_NAME.length - 1) {
            throw new IllegalArgumentException(TOKEN_ID_EXCEPTION_PREFIX + id);
        }
        String name = TOKEN_VALUE_TO_NAME[id];
        if (name == null) {
            throw new IllegalArgumentException(TOKEN_ID_EXCEPTION_PREFIX + id);
        }
        return name;
    }

    public static int getTokenId(String name) {
        Integer id = TOKEN_NAME_TO_VALUE.get(name);
        if (id == null) {
            throw new IllegalArgumentException(TOKEN_NAME_EXCEPTION_PREFIX + name);
        }
        return id;
    }

    public static String getShortDescription(String name) {
        if (!TOKEN_NAME_TO_VALUE.containsKey(name)) {
            throw new IllegalArgumentException(TOKEN_NAME_EXCEPTION_PREFIX + name);
        }
        String tokenTypes = "com.puppycrawl.tools.checkstyle.api.tokentypes";
        ResourceBundle bundle = ResourceBundle.getBundle("com.puppycrawl.tools.checkstyle.api.tokentypes");
        return bundle.getString(name);
    }

    public static boolean isCommentType(int type) {
        return type == 144 || type == 145 || type == 182 || type == 183;
    }

    public static boolean isCommentType(String type) {
        return TokenUtils.isCommentType(TokenUtils.getTokenId(type));
    }

    static {
        ImmutableMap.Builder<String, Integer> builder = ImmutableMap.builder();
        Field[] fields = TokenTypes.class.getDeclaredFields();
        String[] tempTokenValueToName = ArrayUtils.EMPTY_STRING_ARRAY;
        for (Field field : fields) {
            if (field.getType() != Integer.TYPE) continue;
            String name = field.getName();
            int tokenValue = TokenUtils.getIntFromField(field, name);
            builder.put(name, tokenValue);
            if (tokenValue > tempTokenValueToName.length - 1) {
                String[] temp = new String[tokenValue + 1];
                System.arraycopy(tempTokenValueToName, 0, temp, 0, tempTokenValueToName.length);
                tempTokenValueToName = temp;
            }
            tempTokenValueToName[tokenValue] = name;
        }
        TOKEN_NAME_TO_VALUE = builder.build();
        TOKEN_VALUE_TO_NAME = tempTokenValueToName;
        Collection values = TOKEN_NAME_TO_VALUE.values();
        Integer[] ids = ((ImmutableCollection)values).toArray(new Integer[((AbstractCollection)values).size()]);
        TOKEN_IDS = ArrayUtils.toPrimitive(ids);
    }
}

