/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtility;
import java.util.Collections;
import java.util.Set;

public final class IllegalThrowsCheck
extends Check {
    public static final String MSG_KEY = "illegal.throw";
    private boolean ignoreOverriddenMethods = true;
    private final Set<String> ignoredMethodNames = Sets.newHashSet("finalize");
    private final Set<String> illegalClassNames = Sets.newHashSet("Error", "RuntimeException", "Throwable", "java.lang.Error", "java.lang.RuntimeException", "java.lang.Throwable");

    public void setIllegalClassNames(String ... classNames) {
        this.illegalClassNames.clear();
        for (String name : classNames) {
            this.illegalClassNames.add(name);
            int lastDot = name.lastIndexOf(46);
            if (lastDot <= 0 || lastDot >= name.length() - 1) continue;
            String shortName = name.substring(name.lastIndexOf(46) + 1);
            this.illegalClassNames.add(shortName);
        }
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{81};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{81};
    }

    @Override
    public void visitToken(DetailAST detailAST) {
        DetailAST methodDef = detailAST.getParent();
        if (!this.isIgnorableMethod(methodDef)) {
            for (DetailAST token = detailAST.getFirstChild(); token != null; token = token.getNextSibling()) {
                FullIdent ident;
                if (token.getType() == 74 || !this.illegalClassNames.contains((ident = FullIdent.createFullIdent(token)).getText())) continue;
                this.log(token, MSG_KEY, ident.getText());
            }
        }
    }

    private boolean isIgnorableMethod(DetailAST methodDef) {
        return this.shouldIgnoreMethod(methodDef.findFirstToken(58).getText()) || this.ignoreOverriddenMethods && (AnnotationUtility.containsAnnotation(methodDef, "Override") || AnnotationUtility.containsAnnotation(methodDef, "java.lang.Override"));
    }

    private boolean shouldIgnoreMethod(String name) {
        return this.ignoredMethodNames.contains(name);
    }

    public void setIgnoredMethodNames(String ... methodNames) {
        this.ignoredMethodNames.clear();
        Collections.addAll(this.ignoredMethodNames, methodNames);
    }

    public void setIgnoreOverriddenMethods(boolean ignoreOverriddenMethods) {
        this.ignoreOverriddenMethods = ignoreOverriddenMethods;
    }
}

