/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.Iterator;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;

public class IsStaticExpressionVisitor
implements ExpressionVisitor {
    public static final IsStaticExpressionVisitor VISITOR = new IsStaticExpressionVisitor();

    protected IsStaticExpressionVisitor() {
    }

    @Override
    public Boolean visit(NilExpression expression, Object data) {
        return true;
    }

    @Override
    public Boolean visit(Add expression, Object data) {
        boolean isStatic = (Boolean)expression.getExpression1().accept(this, data);
        if (!isStatic) {
            return false;
        }
        isStatic = (Boolean)expression.getExpression2().accept(this, data);
        return isStatic;
    }

    @Override
    public Boolean visit(Divide expression, Object data) {
        boolean isStatic = (Boolean)expression.getExpression1().accept(this, data);
        if (!isStatic) {
            return false;
        }
        isStatic = (Boolean)expression.getExpression2().accept(this, data);
        return isStatic;
    }

    @Override
    public Boolean visit(Function expression, Object data) {
        boolean isStatic;
        block1: {
            Expression parameter;
            isStatic = true;
            if (expression.getParameters() == null) break block1;
            Iterator<Expression> i$ = expression.getParameters().iterator();
            while (i$.hasNext() && (isStatic = ((Boolean)(parameter = i$.next()).accept(this, data)).booleanValue())) {
            }
        }
        return isStatic;
    }

    @Override
    public Boolean visit(Literal expression, Object data) {
        return true;
    }

    @Override
    public Boolean visit(Multiply expression, Object data) {
        boolean isStatic = (Boolean)expression.getExpression1().accept(this, data);
        if (!isStatic) {
            return false;
        }
        isStatic = (Boolean)expression.getExpression2().accept(this, data);
        return isStatic;
    }

    @Override
    public Boolean visit(PropertyName expression, Object data) {
        return false;
    }

    @Override
    public Boolean visit(Subtract expression, Object data) {
        boolean isStatic = (Boolean)expression.getExpression1().accept(this, data);
        if (!isStatic) {
            return false;
        }
        isStatic = (Boolean)expression.getExpression2().accept(this, data);
        return isStatic;
    }
}

