/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.collection;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.SchemaNotFoundException;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureTypes;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

@Deprecated
public class CollectionDataStore
extends AbstractDataStore {
    SimpleFeatureType featureType;
    FeatureCollection<SimpleFeatureType, SimpleFeature> collection;

    public CollectionDataStore(SimpleFeatureType schema) {
        this.collection = new DefaultFeatureCollection();
        this.featureType = schema;
    }

    public CollectionDataStore(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
        this.collection = collection;
        this.featureType = collection.size() == 0 ? FeatureTypes.EMPTY : collection.getSchema();
    }

    @Override
    public String[] getTypeNames() {
        return new String[]{this.featureType.getTypeName()};
    }

    @Override
    public SimpleFeatureType getSchema(String typeName) throws IOException {
        if (typeName != null && typeName.equals(this.featureType.getTypeName())) {
            return this.featureType;
        }
        throw new IOException(typeName + " not available");
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String typeName) throws IOException {
        return new DelegateFeatureReader<SimpleFeatureType, SimpleFeature>(this.getSchema(typeName), this.collection.features());
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> getCollection() {
        return (SimpleFeatureCollection)this.collection;
    }

    @Override
    protected ReferencedEnvelope getBounds(Query query) throws SchemaNotFoundException {
        String featureTypeName = query.getTypeName();
        if (!this.featureType.getTypeName().equals(featureTypeName)) {
            throw new SchemaNotFoundException(featureTypeName);
        }
        return this.getBoundsInternal(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReferencedEnvelope getBoundsInternal(Query query) {
        ReferencedEnvelope envelope = new ReferencedEnvelope(this.featureType.getCoordinateReferenceSystem());
        try (FeatureIterator<SimpleFeature> iterator = this.collection.features();){
            if (iterator.hasNext()) {
                int count = 1;
                Filter filter = query.getFilter();
                while (iterator.hasNext() && count < query.getMaxFeatures()) {
                    SimpleFeature feature = iterator.next();
                    if (!filter.evaluate(feature)) continue;
                    ++count;
                    envelope.expandToInclude(((Geometry)feature.getDefaultGeometry()).getEnvelopeInternal());
                }
            }
        }
        return envelope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getCount(Query query) throws IOException {
        String featureTypeName = query.getTypeName();
        if (!this.featureType.getTypeName().equals(featureTypeName)) {
            throw new SchemaNotFoundException(featureTypeName);
        }
        int count = 0;
        try (FeatureIterator<SimpleFeature> iterator = this.collection.features();){
            Filter filter = query.getFilter();
            while (iterator.hasNext() && count < query.getMaxFeatures()) {
                if (!filter.evaluate(iterator.next())) continue;
                ++count;
            }
        }
        return count;
    }
}

