/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.measure.quantity.Length;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import org.geotools.styling.Displacement;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.geotools.styling.visitor.Measure;
import org.geotools.styling.visitor.RescalingMode;
import org.opengis.filter.expression.Expression;
import org.opengis.style.GraphicalSymbol;

public class UomRescaleStyleVisitor
extends DuplicatingStyleVisitor {
    double mapScale;

    public UomRescaleStyleVisitor(double mapScale) {
        if (mapScale <= 0.0) {
            throw new IllegalArgumentException("The mapScale is out of range. Value is " + Double.toString(mapScale) + ". It must be positive.");
        }
        this.mapScale = mapScale;
    }

    protected Expression rescale(Expression unscaled, Unit<Length> uom) {
        if (unscaled == null || unscaled.equals(Expression.NIL)) {
            return unscaled;
        }
        Measure m = new Measure(unscaled, uom);
        return RescalingMode.RealWorld.rescaleToExpression(this.ff.literal(this.mapScale), m);
    }

    protected List<Expression> rescale(List<Expression> expressions, Unit<Length> uom) {
        if (expressions == null || expressions.isEmpty()) {
            return expressions;
        }
        ArrayList<Expression> rescaled = new ArrayList<Expression>(expressions.size());
        for (Expression expression : expressions) {
            rescaled.add(this.rescale(expression, uom));
        }
        return rescaled;
    }

    protected String rescale(String unscaled, Unit<Length> uom) {
        if (unscaled == null) {
            return unscaled;
        }
        Measure v = new Measure(unscaled, uom);
        return RescalingMode.RealWorld.rescaleToString(this.mapScale, v);
    }

    protected void rescaleStroke(Stroke stroke, Unit<Length> uom) {
        if (stroke != null) {
            stroke.setWidth(this.rescale(stroke.getWidth(), uom));
            stroke.setDashArray(this.rescale(stroke.dashArray(), uom));
            stroke.setDashOffset(this.rescale(stroke.getDashOffset(), uom));
            this.rescale(stroke.getGraphicFill(), uom);
            this.rescale(stroke.getGraphicStroke(), uom);
        }
    }

    @Override
    public void visit(PointSymbolizer ps) {
        super.visit(ps);
        PointSymbolizer copy = (PointSymbolizer)this.pages.peek();
        Unit<Length> uom = copy.getUnitOfMeasure();
        Graphic copyGraphic = copy.getGraphic();
        this.rescale(copyGraphic, uom);
        copy.setUnitOfMeasure(NonSI.PIXEL);
    }

    private void rescale(Graphic graphic, Unit<Length> unit) {
        if (graphic != null) {
            graphic.setSize(this.rescale(graphic.getSize(), unit));
            graphic.setGap(this.rescale(graphic.getGap(), unit));
            Displacement disp = graphic.getDisplacement();
            if (disp != null) {
                disp.setDisplacementX(this.rescale(disp.getDisplacementX(), unit));
                disp.setDisplacementY(this.rescale(disp.getDisplacementY(), unit));
                graphic.setDisplacement(disp);
            }
            if (graphic.graphicalSymbols() != null) {
                for (GraphicalSymbol gs : graphic.graphicalSymbols()) {
                    if (!(gs instanceof Mark)) continue;
                    Mark mark = (Mark)gs;
                    this.rescaleStroke(mark.getStroke(), unit);
                    this.rescaleFill(mark.getFill(), unit);
                }
            }
        }
    }

    @Override
    public void visit(LineSymbolizer line) {
        super.visit(line);
        LineSymbolizer copy = (LineSymbolizer)this.pages.peek();
        Unit<Length> uom = copy.getUnitOfMeasure();
        Stroke copyStroke = copy.getStroke();
        this.rescaleStroke(copyStroke, uom);
        copy.setUnitOfMeasure(NonSI.PIXEL);
    }

    @Override
    public void visit(PolygonSymbolizer poly) {
        super.visit(poly);
        PolygonSymbolizer copy = (PolygonSymbolizer)this.pages.peek();
        Unit<Length> uom = copy.getUnitOfMeasure();
        this.rescaleStroke(copy.getStroke(), uom);
        this.rescaleFill(copy.getFill(), uom);
        copy.setUnitOfMeasure(NonSI.PIXEL);
    }

    private void rescaleFill(Fill copyFill, Unit<Length> unit) {
        if (copyFill != null) {
            this.rescale(copyFill.getGraphicFill(), unit);
        }
    }

    @Override
    public void visit(TextSymbolizer text) {
        super.visit(text);
        TextSymbolizer copy = (TextSymbolizer)this.pages.peek();
        Unit<Length> uom = copy.getUnitOfMeasure();
        for (Font font : copy.fonts()) {
            font.setSize(this.rescale(font.getSize(), uom));
        }
        LabelPlacement placement = copy.getLabelPlacement();
        if (placement instanceof PointPlacement) {
            PointPlacement pointPlacement = (PointPlacement)placement;
            Displacement disp = pointPlacement.getDisplacement();
            if (disp != null) {
                disp.setDisplacementX(this.rescale(disp.getDisplacementX(), uom));
                disp.setDisplacementY(this.rescale(disp.getDisplacementY(), uom));
                pointPlacement.setDisplacement(disp);
            }
        } else if (placement instanceof LinePlacement) {
            LinePlacement linePlacement = (LinePlacement)placement;
            linePlacement.setGap(this.rescale(linePlacement.getGap(), uom));
            linePlacement.setInitialGap(this.rescale(linePlacement.getInitialGap(), uom));
            linePlacement.setPerpendicularOffset(this.rescale(linePlacement.getPerpendicularOffset(), uom));
        }
        copy.setLabelPlacement(placement);
        if (copy.getHalo() != null) {
            copy.getHalo().setRadius(this.rescale(copy.getHalo().getRadius(), uom));
        }
        if (copy instanceof TextSymbolizer2) {
            TextSymbolizer2 copy2 = (TextSymbolizer2)copy;
            this.rescale(copy2.getGraphic(), uom);
        }
        Map<String, String> options = copy.getOptions();
        this.scaleIntOption(options, "maxDisplacement", uom);
        this.scaleIntOption(options, "spaceAround", uom);
        this.scaleIntOption(options, "minGroupDistance", uom);
        this.scaleIntOption(options, "repeat", uom);
        this.scaleIntOption(options, "autoWrap", uom);
        this.scaleIntArrayOption(options, "graphic-margin", uom);
        copy.setUnitOfMeasure(NonSI.PIXEL);
    }

    private void scaleIntOption(Map<String, String> options, String optionName, Unit<Length> uom) {
        if (options.containsKey(optionName)) {
            String rescaled = this.rescale(options.get(optionName), uom);
            options.put(optionName, this.toInt(rescaled));
        }
    }

    private void scaleIntArrayOption(Map<String, String> options, String optionName, Unit<Length> uom) {
        if (options.containsKey(optionName)) {
            String strValue = options.get(optionName);
            String[] splitted = strValue.split("\\s+");
            StringBuilder sb = new StringBuilder();
            for (String value : splitted) {
                String rescaled = this.rescale(value, uom);
                sb.append(this.toInt(rescaled)).append(" ");
            }
            sb.setLength(sb.length() - 1);
            options.put(optionName, sb.toString());
        }
    }

    String toInt(String value) {
        Double dv = Double.valueOf(value);
        return String.valueOf(dv.intValue());
    }
}

