/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import org.geotools.filter.CompareFilterImpl;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.expression.Expression;

public class BetweenFilterImpl
extends CompareFilterImpl
implements PropertyIsBetween {
    protected Expression middleValue = null;

    @Deprecated
    protected BetweenFilterImpl() {
    }

    public final void addMiddleValue(Expression middleValue) {
        this.setExpression(middleValue);
    }

    public void setExpression(Expression expression) {
        this.middleValue = expression;
    }

    public Expression getExpression() {
        return this.middleValue;
    }

    public Expression getLowerBoundary() {
        return this.getExpression1();
    }

    public void setLowerBoundary(Expression lowerBounds) {
        this.setExpression1(lowerBounds);
    }

    public Expression getUpperBoundary() {
        return this.getExpression2();
    }

    public void setUpperBoundary(Expression upperBounds) {
        this.setExpression2(upperBounds);
    }

    public boolean evaluate(Object feature) {
        if (this.middleValue == null) {
            return false;
        }
        Object middleObj = this.eval(this.middleValue, feature);
        Object leftObj = this.eval(this.expression1, feature, middleObj.getClass());
        Object rightObj = this.eval(this.expression2, feature, middleObj.getClass());
        if (leftObj instanceof Number && middleObj instanceof Number && rightObj instanceof Number) {
            double left = ((Number)leftObj).doubleValue();
            double right = ((Number)rightObj).doubleValue();
            double mid = ((Number)middleObj).doubleValue();
            return left <= mid && right >= mid;
        }
        if (leftObj.getClass() == middleObj.getClass() && rightObj.getClass() == middleObj.getClass() && leftObj instanceof Comparable) {
            return ((Comparable)leftObj).compareTo(middleObj) <= 0 && ((Comparable)middleObj).compareTo(rightObj) <= 0;
        }
        String mesg = "Supplied between values are either not compatible or not supported for comparison: " + leftObj + " <= " + middleObj + " <= " + rightObj;
        throw new IllegalArgumentException(mesg);
    }

    @Override
    public String toString() {
        return "[ " + this.expression1.toString() + " < " + this.middleValue + " < " + this.expression2 + " ]";
    }

    @Override
    public boolean equals(Object oFilter) {
        if (oFilter.getClass() == this.getClass()) {
            BetweenFilterImpl bFilter = (BetweenFilterImpl)oFilter;
            return (this.expression1 == bFilter.getExpression1() || this.expression1 != null && this.expression1.equals(bFilter.getExpression1())) && (this.expression2 == bFilter.getExpression2() || this.expression2 != null && this.expression2.equals(bFilter.getExpression2())) && (this.expression1 == bFilter.getExpression() || this.middleValue != null && this.middleValue.equals(bFilter.getExpression()));
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.expression1 == null ? 0 : this.expression1.hashCode());
        result = 37 * result + (this.middleValue == null ? 0 : this.middleValue.hashCode());
        result = 37 * result + (this.expression2 == null ? 0 : this.expression2.hashCode());
        return result;
    }

    @Override
    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((PropertyIsBetween)this, extraData);
    }
}

