/*
 * Decompiled with CFR 0.152.
 */
package relcontext.relationfix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import relcontext.relationfix.RelationFixer;

public class AssociatedStreetFixer
extends RelationFixer {
    public AssociatedStreetFixer() {
        super("associatedStreet");
    }

    @Override
    public boolean isRelationGood(Relation rel) {
        for (RelationMember m : rel.getMembers()) {
            if (m.getType().equals((Object)OsmPrimitiveType.NODE) && !"house".equals(m.getRole())) {
                this.setWarningMessage(I18n.tr((String)"Node without ''house'' role found", (Object[])new Object[0]));
                return false;
            }
            if (m.getType().equals((Object)OsmPrimitiveType.WAY) && !"house".equals(m.getRole()) && !"street".equals(m.getRole())) {
                this.setWarningMessage(I18n.tr((String)"Way without ''house'' or ''street'' role found", (Object[])new Object[0]));
                return false;
            }
            if (!m.getType().equals((Object)OsmPrimitiveType.RELATION) || "house".equals(m.getRole())) continue;
            this.setWarningMessage(I18n.tr((String)"Relation without ''house'' role found", (Object[])new Object[0]));
            return false;
        }
        if (!rel.hasKey("name")) {
            this.setWarningMessage(I18n.tr((String)"Relation does not have name", (Object[])new Object[0]));
            return false;
        }
        String streetName = rel.get("name");
        if (streetName == null) {
            streetName = "";
        }
        for (RelationMember m : rel.getMembers()) {
            String anotherName;
            if (!"street".equals(m.getRole()) || streetName.equals(m.getWay().get("name")) || (anotherName = m.getWay().get("name")) == null || anotherName.isEmpty()) continue;
            this.setWarningMessage(I18n.tr((String)"Relation has streets with different names", (Object[])new Object[0]));
            return false;
        }
        this.clearWarningMessage();
        return true;
    }

    @Override
    public Command fixRelation(Relation source) {
        Relation rel = new Relation(source);
        boolean fixed = false;
        for (int i = 0; i < rel.getMembersCount(); ++i) {
            RelationMember m = rel.getMember(i);
            if (m.isNode()) {
                Node node = m.getNode();
                if ("house".equals(m.getRole()) || !node.hasKey("building") && !node.hasKey("addr:housenumber")) continue;
                fixed = true;
                rel.setMember(i, new RelationMember("house", (OsmPrimitive)node));
                continue;
            }
            if (m.isWay()) {
                Way way = m.getWay();
                if (!"street".equals(m.getRole()) && way.hasKey("highway")) {
                    fixed = true;
                    rel.setMember(i, new RelationMember("street", (OsmPrimitive)way));
                    continue;
                }
                if ("house".equals(m.getRole()) || !way.hasKey("building") && !way.hasKey("addr:housenumber")) continue;
                fixed = true;
                rel.setMember(i, new RelationMember("house", (OsmPrimitive)way));
                continue;
            }
            if (!m.isRelation()) continue;
            Relation relation = m.getRelation();
            if ("house".equals(m.getRole()) || !relation.hasKey("building") && !relation.hasKey("addr:housenumber") && !"multipolygon".equals(relation.get("type"))) continue;
            fixed = true;
            rel.setMember(i, new RelationMember("house", (OsmPrimitive)relation));
        }
        HashMap<String, Integer> streetNames = new HashMap<String, Integer>();
        for (RelationMember m : rel.getMembers()) {
            String name;
            if (!"street".equals(m.getRole()) || !m.isWay() || (name = m.getWay().get("name")) == null || name.isEmpty()) continue;
            Integer count = (Integer)streetNames.get(name);
            streetNames.put(name, count != null ? count + 1 : 1);
        }
        String commonName = "";
        Integer commonCount = 0;
        for (Map.Entry entry : streetNames.entrySet()) {
            if ((Integer)entry.getValue() <= commonCount) continue;
            commonCount = (Integer)entry.getValue();
            commonName = (String)entry.getKey();
        }
        if (!rel.hasKey("name") && !commonName.isEmpty()) {
            fixed = true;
            rel.put("name", commonName);
        } else {
            commonName = "";
        }
        ArrayList<ChangeCommand> commandList = new ArrayList<ChangeCommand>();
        if (fixed) {
            commandList.add(new ChangeCommand((OsmPrimitive)source, (OsmPrimitive)rel));
        }
        if (commandList.size() == 0) {
            return null;
        }
        if (commandList.size() == 1) {
            return (Command)commandList.get(0);
        }
        return new SequenceCommand(I18n.tr((String)"fix associatedStreet relation", (Object[])new Object[0]), commandList);
    }
}

