/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.archive.ArchiveReader;
import org.openstreetmap.josm.plugins.opendata.core.io.archive.SevenZipReader;
import org.openstreetmap.josm.plugins.opendata.core.io.archive.ZipReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GmlReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.KmlReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.KmzReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.MifReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.ShpReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.TabReader;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.CsvReader;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.OdsReader;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.XlsReader;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class NetworkReader
extends OsmServerReader {
    private final String url;
    private final AbstractDataSetHandler handler;
    private Class<? extends AbstractReader> readerClass;
    private final boolean promptUser;
    private File file;
    private String filename;
    public static final Map<String, Class<? extends AbstractReader>> FILE_READERS = new HashMap<String, Class<? extends AbstractReader>>();
    public static final Map<String, Class<? extends AbstractReader>> FILE_AND_ARCHIVE_READERS;

    public NetworkReader(String url, AbstractDataSetHandler handler, boolean promptUser) {
        CheckParameterUtil.ensureParameterNotNull((Object)url, (String)"url");
        this.url = url;
        this.handler = handler;
        this.readerClass = null;
        this.promptUser = promptUser;
    }

    public final File getReadFile() {
        return this.file;
    }

    public final String getReadFileName() {
        return this.filename;
    }

    private Class<? extends AbstractReader> findReaderByAttachment() {
        Matcher m;
        String cdisp = this.activeConnection.getHeaderField("Content-disposition");
        if (cdisp != null && (m = Pattern.compile("attachment;.?filename=(.*)").matcher(cdisp)).matches()) {
            this.filename = m.group(1);
            return this.findReaderByExtension(this.filename);
        }
        return null;
    }

    private Class<? extends AbstractReader> findReaderByContentType() {
        String contentType = this.activeConnection.getContentType();
        if (contentType.startsWith("application/zip")) {
            return ZipReader.class;
        }
        if (contentType.startsWith("application/x-7z-compressed")) {
            return SevenZipReader.class;
        }
        if (contentType.startsWith("application/vnd.ms-excel")) {
            return XlsReader.class;
        }
        if (!contentType.startsWith("application/octet-stream")) {
            if (contentType.startsWith("text/csv")) {
                return CsvReader.class;
            }
            if (contentType.startsWith("text/plain")) {
                return CsvReader.class;
            }
            if (!contentType.startsWith("tdyn/html")) {
                Main.warn((String)("Unsupported content type: " + contentType));
            }
        }
        return null;
    }

    private Class<? extends AbstractReader> findReaderByExtension(String filename) {
        filename = filename.replace("\"", "").toLowerCase();
        for (String ext : FILE_AND_ARCHIVE_READERS.keySet()) {
            if (!filename.endsWith("." + ext)) continue;
            return FILE_AND_ARCHIVE_READERS.get(ext);
        }
        return null;
    }

    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        InputStream in;
        block72: {
            ProgressMonitor instance;
            block71: {
                block70: {
                    block69: {
                        block68: {
                            block67: {
                                block66: {
                                    block65: {
                                        block64: {
                                            block63: {
                                                block62: {
                                                    in = null;
                                                    instance = null;
                                                    in = this.getInputStreamRaw(this.url, progressMonitor);
                                                    if (in != null) break block62;
                                                    DataSet dataSet = null;
                                                    progressMonitor.finishTask();
                                                    try {
                                                        this.activeConnection = null;
                                                        if (in != null) {
                                                            in.close();
                                                        }
                                                    }
                                                    catch (Exception exception) {
                                                        // empty catch block
                                                    }
                                                    return dataSet;
                                                }
                                                progressMonitor.subTask(I18n.tr((String)"Downloading data...", (Object[])new Object[0]));
                                                if (this.readerClass == null) {
                                                    this.readerClass = this.findReaderByAttachment();
                                                }
                                                if (this.readerClass == null) {
                                                    this.readerClass = this.findReaderByExtension(this.url);
                                                }
                                                if (this.readerClass == null) {
                                                    this.readerClass = this.findReaderByContentType();
                                                }
                                                if (this.readerClass == null) {
                                                    throw new OsmTransferException("Cannot find appropriate reader !");
                                                }
                                                if (this.findReaderByExtension(this.url) != null) {
                                                    this.filename = this.url.substring(this.url.lastIndexOf(47) + 1);
                                                }
                                                instance = progressMonitor.createSubTaskMonitor(-1, false);
                                                if (!this.readerClass.equals(ZipReader.class) && !this.readerClass.equals(SevenZipReader.class)) break block63;
                                                ArchiveReader zipReader = this.readerClass.equals(ZipReader.class) ? new ZipReader(in, this.handler, this.promptUser) : new SevenZipReader(in, this.handler, this.promptUser);
                                                DataSet ds = zipReader.parseDoc(instance);
                                                this.file = zipReader.getReadFile();
                                                DataSet dataSet = ds;
                                                progressMonitor.finishTask();
                                                try {
                                                    this.activeConnection = null;
                                                    if (in != null) {
                                                        in.close();
                                                    }
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                                return dataSet;
                                            }
                                            if (!this.readerClass.equals(KmlReader.class)) break block64;
                                            DataSet zipReader = KmlReader.parseDataSet(in, instance);
                                            progressMonitor.finishTask();
                                            try {
                                                this.activeConnection = null;
                                                if (in != null) {
                                                    in.close();
                                                }
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                            return zipReader;
                                        }
                                        if (!this.readerClass.equals(KmzReader.class)) break block65;
                                        DataSet zipReader = KmzReader.parseDataSet(in, instance);
                                        progressMonitor.finishTask();
                                        try {
                                            this.activeConnection = null;
                                            if (in != null) {
                                                in.close();
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        return zipReader;
                                    }
                                    if (!this.readerClass.equals(MifReader.class)) break block66;
                                    DataSet zipReader = MifReader.parseDataSet(in, null, this.handler, instance);
                                    progressMonitor.finishTask();
                                    try {
                                        this.activeConnection = null;
                                        if (in != null) {
                                            in.close();
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    return zipReader;
                                }
                                if (!this.readerClass.equals(ShpReader.class)) break block67;
                                DataSet zipReader = ShpReader.parseDataSet(in, null, this.handler, instance);
                                progressMonitor.finishTask();
                                try {
                                    this.activeConnection = null;
                                    if (in != null) {
                                        in.close();
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return zipReader;
                            }
                            if (!this.readerClass.equals(TabReader.class)) break block68;
                            DataSet zipReader = TabReader.parseDataSet(in, null, this.handler, instance);
                            progressMonitor.finishTask();
                            try {
                                this.activeConnection = null;
                                if (in != null) {
                                    in.close();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return zipReader;
                        }
                        if (!this.readerClass.equals(CsvReader.class)) break block69;
                        DataSet zipReader = CsvReader.parseDataSet(in, this.handler, instance);
                        progressMonitor.finishTask();
                        try {
                            this.activeConnection = null;
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return zipReader;
                    }
                    if (!this.readerClass.equals(OdsReader.class)) break block70;
                    DataSet zipReader = OdsReader.parseDataSet(in, this.handler, instance);
                    progressMonitor.finishTask();
                    try {
                        this.activeConnection = null;
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return zipReader;
                }
                if (!this.readerClass.equals(XlsReader.class)) break block71;
                DataSet zipReader = XlsReader.parseDataSet(in, this.handler, instance);
                progressMonitor.finishTask();
                try {
                    this.activeConnection = null;
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return zipReader;
            }
            if (!this.readerClass.equals(GmlReader.class)) break block72;
            DataSet zipReader = GmlReader.parseDataSet(in, this.handler, instance);
            progressMonitor.finishTask();
            try {
                this.activeConnection = null;
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return zipReader;
        }
        try {
            try {
                throw new IllegalArgumentException("Unsupported reader class: " + this.readerClass.getName());
            }
            catch (OsmTransferException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.cancel) {
                    DataSet dataSet = null;
                    return dataSet;
                }
                throw new OsmTransferException((Throwable)e);
            }
        }
        finally {
            progressMonitor.finishTask();
            try {
                this.activeConnection = null;
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    static {
        FILE_READERS.put("csv", CsvReader.class);
        FILE_READERS.put("kml", KmlReader.class);
        FILE_READERS.put("kmz", KmzReader.class);
        FILE_READERS.put("gml", GmlReader.class);
        FILE_READERS.put("xls", XlsReader.class);
        FILE_READERS.put("ods", OdsReader.class);
        FILE_READERS.put("shp", ShpReader.class);
        FILE_READERS.put("mif", MifReader.class);
        FILE_READERS.put("tab", TabReader.class);
        FILE_AND_ARCHIVE_READERS = new HashMap<String, Class<? extends AbstractReader>>(FILE_READERS);
        FILE_AND_ARCHIVE_READERS.put("zip", ZipReader.class);
        FILE_AND_ARCHIVE_READERS.put("7z", SevenZipReader.class);
    }
}

