/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.multimap;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.MultiSet;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.functors.InstantiateFactory;
import org.apache.commons.collections4.iterators.EmptyMapIterator;
import org.apache.commons.collections4.iterators.IteratorChain;
import org.apache.commons.collections4.iterators.LazyIteratorChain;
import org.apache.commons.collections4.iterators.TransformIterator;
import org.apache.commons.collections4.keyvalue.AbstractMapEntry;
import org.apache.commons.collections4.set.UnmodifiableSet;

public abstract class AbstractMultiValuedMap<K, V>
implements MultiValuedMap<K, V>,
Serializable {
    private static final long serialVersionUID = 20150612L;
    private final Factory<? extends Collection<V>> collectionFactory;
    private transient Collection<V> valuesView;
    private transient EntryValues entryValuesView;
    private transient KeysMultiSet keysMultiSetView;
    private final Map<K, Collection<V>> map;

    protected <C extends Collection<V>> AbstractMultiValuedMap(Map<K, ? super C> map, Class<C> collectionClazz) {
        if (map == null) {
            throw new NullPointerException("Map must not be null.");
        }
        this.map = map;
        this.collectionFactory = new InstantiateFactory<C>(collectionClazz);
    }

    protected <C extends Collection<V>> AbstractMultiValuedMap(Map<K, ? super C> map, Class<C> collectionClazz, int initialCollectionCapacity) {
        if (map == null) {
            throw new NullPointerException("Map must not be null.");
        }
        if (initialCollectionCapacity < 0) {
            throw new IllegalArgumentException("InitialCapacity must not be negative.");
        }
        this.map = map;
        this.collectionFactory = new InstantiateFactory<C>(collectionClazz, new Class[]{Integer.TYPE}, new Object[]{initialCollectionCapacity});
    }

    protected Map<K, Collection<V>> getMap() {
        return this.map;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getMap().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public boolean containsMapping(Object key, Object value) {
        Collection<V> coll = this.getMap().get(key);
        return coll != null && coll.contains(value);
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        return this.entryValuesView != null ? this.entryValuesView : (this.entryValuesView = new EntryValues());
    }

    @Override
    public Collection<V> get(K key) {
        return new WrappedCollection(key);
    }

    @Override
    public Collection<V> remove(Object key) {
        return CollectionUtils.emptyIfNull(this.getMap().remove(key));
    }

    @Override
    public boolean removeMapping(Object key, Object value) {
        Collection<V> coll = this.getMap().get(key);
        if (coll == null) {
            return false;
        }
        boolean changed = coll.remove(value);
        if (coll.isEmpty()) {
            this.getMap().remove(key);
        }
        return changed;
    }

    @Override
    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.getMap().keySet();
    }

    @Override
    public int size() {
        int size = 0;
        for (Collection<V> col : this.getMap().values()) {
            size += col.size();
        }
        return size;
    }

    @Override
    public Collection<V> values() {
        Values vs = this.valuesView;
        return vs != null ? vs : (this.valuesView = new Values());
    }

    @Override
    public void clear() {
        this.getMap().clear();
    }

    @Override
    public boolean put(K key, V value) {
        Collection<V> coll = this.getMap().get(key);
        if (coll == null) {
            coll = this.createCollection();
            if (coll.add(value)) {
                this.getMap().put(key, coll);
                return true;
            }
            return false;
        }
        return coll.add(value);
    }

    @Override
    public boolean putAll(Map<? extends K, ? extends V> map) {
        if (map == null) {
            throw new NullPointerException("Map must not be null.");
        }
        boolean changed = false;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            changed |= this.put(entry.getKey(), entry.getValue());
        }
        return changed;
    }

    @Override
    public boolean putAll(MultiValuedMap<? extends K, ? extends V> map) {
        if (map == null) {
            throw new NullPointerException("Map must not be null.");
        }
        boolean changed = false;
        for (Map.Entry<K, V> entry : map.entries()) {
            changed |= this.put(entry.getKey(), entry.getValue());
        }
        return changed;
    }

    @Override
    public MultiSet<K> keys() {
        return this.keysMultiSetView != null ? this.keysMultiSetView : (this.keysMultiSetView = new KeysMultiSet());
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        return this.getMap();
    }

    @Override
    public boolean putAll(K key, Iterable<? extends V> values) {
        if (values == null) {
            throw new NullPointerException("Values must not be null.");
        }
        if (values instanceof Collection) {
            Collection valueCollection = (Collection)values;
            return !valueCollection.isEmpty() && this.get(key).addAll(valueCollection);
        }
        Iterator<V> it = values.iterator();
        return it.hasNext() && CollectionUtils.addAll(this.get(key), it);
    }

    @Override
    public MapIterator<K, V> mapIterator() {
        if (this.size() == 0) {
            return EmptyMapIterator.emptyMapIterator();
        }
        return new MultiValuedMapIterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MultiValuedMap) {
            return this.asMap().equals(((MultiValuedMap)obj).asMap());
        }
        return false;
    }

    public int hashCode() {
        return this.getMap().hashCode();
    }

    public String toString() {
        return this.getMap().toString();
    }

    protected Collection<V> createCollection() {
        return this.collectionFactory.create();
    }

    private class ValuesIterator
    implements Iterator<V> {
        private final Object key;
        private final Collection<V> values;
        private final Iterator<V> iterator;

        public ValuesIterator(Object key) {
            this.key = key;
            this.values = AbstractMultiValuedMap.this.getMap().get(key);
            this.iterator = this.values.iterator();
        }

        @Override
        public void remove() {
            this.iterator.remove();
            if (this.values.isEmpty()) {
                AbstractMultiValuedMap.this.remove(this.key);
            }
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            return this.iterator.next();
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            IteratorChain chain = new IteratorChain();
            for (Object k : AbstractMultiValuedMap.this.keySet()) {
                chain.addIterator(new ValuesIterator(k));
            }
            return chain;
        }

        @Override
        public int size() {
            return AbstractMultiValuedMap.this.size();
        }

        @Override
        public void clear() {
            AbstractMultiValuedMap.this.clear();
        }
    }

    private class MultiValuedMapIterator
    implements MapIterator<K, V> {
        private final Iterator<Map.Entry<K, V>> it;
        private Map.Entry<K, V> current = null;

        public MultiValuedMapIterator() {
            this.it = AbstractMultiValuedMap.this.entries().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public K next() {
            this.current = this.it.next();
            return this.current.getKey();
        }

        @Override
        public K getKey() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            return this.current.getKey();
        }

        @Override
        public V getValue() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            return this.current.getValue();
        }

        @Override
        public void remove() {
            this.it.remove();
        }

        @Override
        public V setValue(V value) {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            return this.current.setValue(value);
        }
    }

    private class MultiValuedMapEntry
    extends AbstractMapEntry<K, V> {
        public MultiValuedMapEntry(K key, V value) {
            super(key, value);
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryValues
    extends AbstractCollection<Map.Entry<K, V>> {
        private EntryValues() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new LazyIteratorChain<Map.Entry<K, V>>(){
                final Collection<K> keysCol;
                final Iterator<K> keyIterator;
                {
                    this.keysCol = new ArrayList(AbstractMultiValuedMap.this.getMap().keySet());
                    this.keyIterator = this.keysCol.iterator();
                }

                @Override
                protected Iterator<? extends Map.Entry<K, V>> nextIterator(int count) {
                    if (!this.keyIterator.hasNext()) {
                        return null;
                    }
                    final Object key = this.keyIterator.next();
                    Transformer entryTransformer = new Transformer<V, Map.Entry<K, V>>(){

                        @Override
                        public Map.Entry<K, V> transform(V input) {
                            return new MultiValuedMapEntry(key, input);
                        }
                    };
                    return new TransformIterator(new ValuesIterator(key), entryTransformer);
                }
            };
        }

        @Override
        public int size() {
            return AbstractMultiValuedMap.this.size();
        }
    }

    private class KeysMultiSet
    implements MultiSet<K> {
        private KeysMultiSet() {
        }

        @Override
        public boolean addAll(Collection<? extends K> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractMultiValuedMap.this.getMap().containsKey(o);
        }

        @Override
        public boolean isEmpty() {
            return AbstractMultiValuedMap.this.getMap().isEmpty();
        }

        @Override
        public Object[] toArray() {
            Object[] result = new Object[this.size()];
            int i = 0;
            for (Object current : AbstractMultiValuedMap.this.getMap().keySet()) {
                for (int index = this.getCount(current); index > 0; --index) {
                    result[i++] = current;
                }
            }
            return result;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            int size = this.size();
            if (array.length < size) {
                Object[] unchecked = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
                array = unchecked;
            }
            int i = 0;
            for (Object current : AbstractMultiValuedMap.this.getMap().keySet()) {
                for (int index = this.getCount(current); index > 0; --index) {
                    Object unchecked = current;
                    array[i++] = unchecked;
                }
            }
            while (i < array.length) {
                array[i++] = null;
            }
            return array;
        }

        @Override
        public int getCount(Object object) {
            int count = 0;
            Collection col = AbstractMultiValuedMap.this.getMap().get(object);
            if (col != null) {
                count = col.size();
            }
            return count;
        }

        @Override
        public int setCount(K object, int count) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(K object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int add(K object, int nCopies) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int remove(Object object, int nCopies) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<K> uniqueSet() {
            return UnmodifiableSet.unmodifiableSet(AbstractMultiValuedMap.this.keySet());
        }

        @Override
        public Set<MultiSet.Entry<K>> entrySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return AbstractMultiValuedMap.this.size();
        }

        @Override
        public boolean containsAll(Collection<?> coll) {
            Iterator<?> e = coll.iterator();
            while (e.hasNext()) {
                if (this.contains(e.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<K> iterator() {
            return new LazyIteratorChain<K>(){
                final Iterator<K> keyIterator;
                {
                    this.keyIterator = AbstractMultiValuedMap.this.getMap().keySet().iterator();
                }

                @Override
                protected Iterator<? extends K> nextIterator(int count) {
                    if (!this.keyIterator.hasNext()) {
                        return null;
                    }
                    final Object key = this.keyIterator.next();
                    final Iterator colIterator = AbstractMultiValuedMap.this.getMap().get(key).iterator();
                    Iterator nextIt = new Iterator<K>(){

                        @Override
                        public boolean hasNext() {
                            return colIterator.hasNext();
                        }

                        @Override
                        public K next() {
                            colIterator.next();
                            return key;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                    return nextIt;
                }
            };
        }

        public String toString() {
            if (this.size() == 0) {
                return "[]";
            }
            StringBuilder buf = new StringBuilder();
            buf.append('[');
            Iterator it = this.uniqueSet().iterator();
            while (it.hasNext()) {
                Object current = it.next();
                int count = this.getCount(current);
                buf.append(current);
                buf.append(':');
                buf.append(count);
                if (!it.hasNext()) continue;
                buf.append(", ");
            }
            buf.append(']');
            return buf.toString();
        }
    }

    protected class WrappedCollection
    implements Collection<V> {
        protected final K key;

        public WrappedCollection(K key) {
            this.key = key;
        }

        protected Collection<V> getMapping() {
            return AbstractMultiValuedMap.this.getMap().get(this.key);
        }

        @Override
        public boolean add(V value) {
            Collection coll = this.getMapping();
            if (coll == null) {
                coll = AbstractMultiValuedMap.this.createCollection();
                AbstractMultiValuedMap.this.map.put(this.key, coll);
            }
            return coll.add(value);
        }

        @Override
        public boolean addAll(Collection<? extends V> other) {
            Collection coll = this.getMapping();
            if (coll == null) {
                coll = AbstractMultiValuedMap.this.createCollection();
                AbstractMultiValuedMap.this.map.put(this.key, coll);
            }
            return coll.addAll(other);
        }

        @Override
        public void clear() {
            Collection coll = this.getMapping();
            if (coll != null) {
                coll.clear();
                AbstractMultiValuedMap.this.remove(this.key);
            }
        }

        @Override
        public Iterator<V> iterator() {
            Collection coll = this.getMapping();
            if (coll == null) {
                return IteratorUtils.EMPTY_ITERATOR;
            }
            return new ValuesIterator(this.key);
        }

        @Override
        public int size() {
            Collection coll = this.getMapping();
            return coll == null ? 0 : coll.size();
        }

        @Override
        public boolean contains(Object obj) {
            Collection coll = this.getMapping();
            return coll == null ? false : coll.contains(obj);
        }

        @Override
        public boolean containsAll(Collection<?> other) {
            Collection coll = this.getMapping();
            return coll == null ? false : coll.containsAll(other);
        }

        @Override
        public boolean isEmpty() {
            Collection coll = this.getMapping();
            return coll == null ? true : coll.isEmpty();
        }

        @Override
        public boolean remove(Object item) {
            Collection coll = this.getMapping();
            if (coll == null) {
                return false;
            }
            boolean result = coll.remove(item);
            if (coll.isEmpty()) {
                AbstractMultiValuedMap.this.remove(this.key);
            }
            return result;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            Collection coll = this.getMapping();
            if (coll == null) {
                return false;
            }
            boolean result = coll.removeAll(c);
            if (coll.isEmpty()) {
                AbstractMultiValuedMap.this.remove(this.key);
            }
            return result;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            Collection coll = this.getMapping();
            if (coll == null) {
                return false;
            }
            boolean result = coll.retainAll(c);
            if (coll.isEmpty()) {
                AbstractMultiValuedMap.this.remove(this.key);
            }
            return result;
        }

        @Override
        public Object[] toArray() {
            Collection coll = this.getMapping();
            if (coll == null) {
                return CollectionUtils.EMPTY_COLLECTION.toArray();
            }
            return coll.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            Collection coll = this.getMapping();
            if (coll == null) {
                return CollectionUtils.EMPTY_COLLECTION.toArray(a);
            }
            return coll.toArray(a);
        }

        public String toString() {
            Collection coll = this.getMapping();
            if (coll == null) {
                return CollectionUtils.EMPTY_COLLECTION.toString();
            }
            return coll.toString();
        }
    }
}

