/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.record.formula.AddPtg;
import org.apache.poi.hssf.record.formula.Area3DPtg;
import org.apache.poi.hssf.record.formula.AreaErrPtg;
import org.apache.poi.hssf.record.formula.AreaNPtg;
import org.apache.poi.hssf.record.formula.AreaPtg;
import org.apache.poi.hssf.record.formula.ArrayPtg;
import org.apache.poi.hssf.record.formula.AttrPtg;
import org.apache.poi.hssf.record.formula.BoolPtg;
import org.apache.poi.hssf.record.formula.ConcatPtg;
import org.apache.poi.hssf.record.formula.DeletedArea3DPtg;
import org.apache.poi.hssf.record.formula.DeletedRef3DPtg;
import org.apache.poi.hssf.record.formula.DividePtg;
import org.apache.poi.hssf.record.formula.EqualPtg;
import org.apache.poi.hssf.record.formula.ErrPtg;
import org.apache.poi.hssf.record.formula.ExpPtg;
import org.apache.poi.hssf.record.formula.FuncPtg;
import org.apache.poi.hssf.record.formula.FuncVarPtg;
import org.apache.poi.hssf.record.formula.GreaterEqualPtg;
import org.apache.poi.hssf.record.formula.GreaterThanPtg;
import org.apache.poi.hssf.record.formula.IntPtg;
import org.apache.poi.hssf.record.formula.IntersectionPtg;
import org.apache.poi.hssf.record.formula.LessEqualPtg;
import org.apache.poi.hssf.record.formula.LessThanPtg;
import org.apache.poi.hssf.record.formula.MemAreaPtg;
import org.apache.poi.hssf.record.formula.MemErrPtg;
import org.apache.poi.hssf.record.formula.MemFuncPtg;
import org.apache.poi.hssf.record.formula.MissingArgPtg;
import org.apache.poi.hssf.record.formula.MultiplyPtg;
import org.apache.poi.hssf.record.formula.NamePtg;
import org.apache.poi.hssf.record.formula.NameXPtg;
import org.apache.poi.hssf.record.formula.NotEqualPtg;
import org.apache.poi.hssf.record.formula.NumberPtg;
import org.apache.poi.hssf.record.formula.ParenthesisPtg;
import org.apache.poi.hssf.record.formula.PercentPtg;
import org.apache.poi.hssf.record.formula.PowerPtg;
import org.apache.poi.hssf.record.formula.RangePtg;
import org.apache.poi.hssf.record.formula.Ref3DPtg;
import org.apache.poi.hssf.record.formula.RefErrorPtg;
import org.apache.poi.hssf.record.formula.RefNPtg;
import org.apache.poi.hssf.record.formula.RefPtg;
import org.apache.poi.hssf.record.formula.StringPtg;
import org.apache.poi.hssf.record.formula.SubtractPtg;
import org.apache.poi.hssf.record.formula.TblPtg;
import org.apache.poi.hssf.record.formula.UnaryMinusPtg;
import org.apache.poi.hssf.record.formula.UnaryPlusPtg;
import org.apache.poi.hssf.record.formula.UnionPtg;
import org.apache.poi.hssf.record.formula.UnknownPtg;
import org.apache.poi.util.LittleEndianByteArrayOutputStream;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public abstract class Ptg {
    public static final Ptg[] EMPTY_PTG_ARRAY = new Ptg[0];
    public static final byte CLASS_REF = 0;
    public static final byte CLASS_VALUE = 32;
    public static final byte CLASS_ARRAY = 64;
    private byte ptgClass = 0;

    public static Ptg[] readTokens(int n, LittleEndianInput littleEndianInput) {
        int n2;
        Ptg[] ptgArray;
        ArrayList<Ptg> arrayList = new ArrayList<Ptg>(4 + n / 2);
        boolean bl = false;
        for (n2 = 0; n2 < n; n2 += ptgArray.getSize()) {
            ptgArray = Ptg.createPtg(littleEndianInput);
            if (ptgArray instanceof ArrayPtg.Initial) {
                bl = true;
            }
            arrayList.add((Ptg)ptgArray);
        }
        if (n2 != n) {
            throw new RuntimeException("Ptg array size mismatch");
        }
        if (bl) {
            ptgArray = Ptg.toPtgArray(arrayList);
            for (int i = 0; i < ptgArray.length; ++i) {
                if (!(ptgArray[i] instanceof ArrayPtg.Initial)) continue;
                ptgArray[i] = ((ArrayPtg.Initial)ptgArray[i]).finishReading(littleEndianInput);
            }
            return ptgArray;
        }
        return Ptg.toPtgArray(arrayList);
    }

    public static Ptg createPtg(LittleEndianInput littleEndianInput) {
        byte by = littleEndianInput.readByte();
        if (by < 32) {
            return Ptg.createBasePtg(by, littleEndianInput);
        }
        Ptg ptg = Ptg.createClassifiedPtg(by, littleEndianInput);
        if (by >= 96) {
            ptg.setClass((byte)64);
        } else if (by >= 64) {
            ptg.setClass((byte)32);
        } else {
            ptg.setClass((byte)0);
        }
        return ptg;
    }

    private static Ptg createClassifiedPtg(byte by, LittleEndianInput littleEndianInput) {
        int n = by & 0x1F | 0x20;
        switch (n) {
            case 32: {
                return new ArrayPtg.Initial(littleEndianInput);
            }
            case 33: {
                return FuncPtg.create(littleEndianInput);
            }
            case 34: {
                return FuncVarPtg.create(littleEndianInput);
            }
            case 35: {
                return new NamePtg(littleEndianInput);
            }
            case 36: {
                return new RefPtg(littleEndianInput);
            }
            case 37: {
                return new AreaPtg(littleEndianInput);
            }
            case 38: {
                return new MemAreaPtg(littleEndianInput);
            }
            case 39: {
                return new MemErrPtg(littleEndianInput);
            }
            case 41: {
                return new MemFuncPtg(littleEndianInput);
            }
            case 42: {
                return new RefErrorPtg(littleEndianInput);
            }
            case 43: {
                return new AreaErrPtg(littleEndianInput);
            }
            case 44: {
                return new RefNPtg(littleEndianInput);
            }
            case 45: {
                return new AreaNPtg(littleEndianInput);
            }
            case 57: {
                return new NameXPtg(littleEndianInput);
            }
            case 58: {
                return new Ref3DPtg(littleEndianInput);
            }
            case 59: {
                return new Area3DPtg(littleEndianInput);
            }
            case 60: {
                return new DeletedRef3DPtg(littleEndianInput);
            }
            case 61: {
                return new DeletedArea3DPtg(littleEndianInput);
            }
        }
        throw new UnsupportedOperationException(" Unknown Ptg in Formula: 0x" + Integer.toHexString(by) + " (" + by + ")");
    }

    private static Ptg createBasePtg(byte by, LittleEndianInput littleEndianInput) {
        switch (by) {
            case 0: {
                return new UnknownPtg(by);
            }
            case 1: {
                return new ExpPtg(littleEndianInput);
            }
            case 2: {
                return new TblPtg(littleEndianInput);
            }
            case 3: {
                return AddPtg.instance;
            }
            case 4: {
                return SubtractPtg.instance;
            }
            case 5: {
                return MultiplyPtg.instance;
            }
            case 6: {
                return DividePtg.instance;
            }
            case 7: {
                return PowerPtg.instance;
            }
            case 8: {
                return ConcatPtg.instance;
            }
            case 9: {
                return LessThanPtg.instance;
            }
            case 10: {
                return LessEqualPtg.instance;
            }
            case 11: {
                return EqualPtg.instance;
            }
            case 12: {
                return GreaterEqualPtg.instance;
            }
            case 13: {
                return GreaterThanPtg.instance;
            }
            case 14: {
                return NotEqualPtg.instance;
            }
            case 15: {
                return IntersectionPtg.instance;
            }
            case 16: {
                return UnionPtg.instance;
            }
            case 17: {
                return RangePtg.instance;
            }
            case 18: {
                return UnaryPlusPtg.instance;
            }
            case 19: {
                return UnaryMinusPtg.instance;
            }
            case 20: {
                return PercentPtg.instance;
            }
            case 21: {
                return ParenthesisPtg.instance;
            }
            case 22: {
                return MissingArgPtg.instance;
            }
            case 23: {
                return new StringPtg(littleEndianInput);
            }
            case 25: {
                return new AttrPtg(littleEndianInput);
            }
            case 28: {
                return ErrPtg.read(littleEndianInput);
            }
            case 29: {
                return BoolPtg.read(littleEndianInput);
            }
            case 30: {
                return new IntPtg(littleEndianInput);
            }
            case 31: {
                return new NumberPtg(littleEndianInput);
            }
        }
        throw new RuntimeException("Unexpected base token id (" + by + ")");
    }

    private static Ptg[] toPtgArray(List<Ptg> list) {
        if (list.isEmpty()) {
            return EMPTY_PTG_ARRAY;
        }
        Ptg[] ptgArray = new Ptg[list.size()];
        list.toArray(ptgArray);
        return ptgArray;
    }

    public static int getEncodedSize(Ptg[] ptgArray) {
        int n = 0;
        for (int i = 0; i < ptgArray.length; ++i) {
            n += ptgArray[i].getSize();
        }
        return n;
    }

    public static int getEncodedSizeWithoutArrayData(Ptg[] ptgArray) {
        int n = 0;
        for (int i = 0; i < ptgArray.length; ++i) {
            Ptg ptg = ptgArray[i];
            if (ptg instanceof ArrayPtg) {
                n += 8;
                continue;
            }
            n += ptg.getSize();
        }
        return n;
    }

    public static int serializePtgs(Ptg[] ptgArray, byte[] byArray, int n) {
        Ptg ptg;
        int n2;
        int n3 = ptgArray.length;
        LittleEndianByteArrayOutputStream littleEndianByteArrayOutputStream = new LittleEndianByteArrayOutputStream(byArray, n);
        ArrayList<Ptg> arrayList = null;
        for (n2 = 0; n2 < n3; ++n2) {
            ptg = ptgArray[n2];
            ptg.write(littleEndianByteArrayOutputStream);
            if (!(ptg instanceof ArrayPtg)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Ptg>(5);
            }
            arrayList.add(ptg);
        }
        if (arrayList != null) {
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                ptg = (ArrayPtg)arrayList.get(n2);
                ((ArrayPtg)ptg).writeTokenValueBytes(littleEndianByteArrayOutputStream);
            }
        }
        return littleEndianByteArrayOutputStream.getWriteIndex() - n;
    }

    public abstract int getSize();

    public abstract void write(LittleEndianOutput var1);

    public abstract String toFormulaString();

    public String toString() {
        return this.getClass().toString();
    }

    public final void setClass(byte by) {
        if (this.isBaseToken()) {
            throw new RuntimeException("setClass should not be called on a base token");
        }
        this.ptgClass = by;
    }

    public final byte getPtgClass() {
        return this.ptgClass;
    }

    public final char getRVAType() {
        if (this.isBaseToken()) {
            return '.';
        }
        switch (this.ptgClass) {
            case 0: {
                return 'R';
            }
            case 32: {
                return 'V';
            }
            case 64: {
                return 'A';
            }
        }
        throw new RuntimeException("Unknown operand class (" + this.ptgClass + ")");
    }

    public abstract byte getDefaultOperandClass();

    public abstract boolean isBaseToken();
}

