/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.service;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.mapdust.service.connector.response.Geometry;
import org.openstreetmap.josm.plugins.mapdust.service.connector.response.MapdustBugContent;
import org.openstreetmap.josm.plugins.mapdust.service.connector.response.MapdustBugProperties;
import org.openstreetmap.josm.plugins.mapdust.service.connector.response.MapdustCommentProperties;
import org.openstreetmap.josm.plugins.mapdust.service.connector.response.MapdustGetBugResponse;
import org.openstreetmap.josm.plugins.mapdust.service.connector.response.MapdustGetBugsResponse;
import org.openstreetmap.josm.plugins.mapdust.service.value.BugType;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBug;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustComment;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustRelevance;
import org.openstreetmap.josm.plugins.mapdust.service.value.Status;

class MapdustConverter {
    MapdustConverter() {
    }

    static MapdustBug buildMapdustBug(MapdustGetBugResponse bugResponse) {
        MapdustBug bug = new MapdustBug();
        if (bugResponse != null) {
            bug.setId(bugResponse.getId());
            Geometry geometry = bugResponse.getGeometry();
            LatLon latLon = null;
            if (geometry != null && geometry.getCoordinates() != null && geometry.getCoordinates().length == 2) {
                Double longitude = geometry.getCoordinates()[0];
                Double latitude = geometry.getCoordinates()[1];
                latLon = new LatLon(latitude.doubleValue(), longitude.doubleValue());
            }
            bug.setLatLon(latLon);
            MapdustBugProperties bugProperties = bugResponse.getProperties();
            if (bugProperties != null) {
                bug.setAddress(bugProperties.getAddress());
                Status status = Status.getStatus(bugProperties.getStatus());
                bug.setStatus(status);
                BugType type = BugType.getType(bugProperties.getType());
                bug.setType(type);
                MapdustRelevance relevance = MapdustRelevance.getMapdustRelevance(bugProperties.getRelevance());
                bug.setRelevance(relevance);
                bug.setDateCreated(bugProperties.getDateCreated());
                bug.setDateUpdated(bugProperties.getDateUpdated());
                bug.setDescription(bugProperties.getDescription());
                boolean isDefDescr = bugProperties.getIsDefaultDescription() == 1 ? Boolean.TRUE : Boolean.FALSE;
                bug.setIsDefaultDescription(isDefDescr);
                bug.setSkoUid(bugProperties.getSkoUid());
                bug.setExtUid(bugProperties.getExtUid());
                bug.setNickname(bugProperties.getNickname());
                bug.setSource(bugProperties.getSource());
                bug.setKmlUrl(bugProperties.getKmlUrl());
                bug.setNumberOfComments(bugProperties.getNumberOfComments());
                MapdustCommentProperties[] commentProperties = bugProperties.getComments();
                MapdustComment[] commentArray = MapdustConverter.buildMapdustCommentArray(bug.getId(), commentProperties);
                bug.setComments(commentArray);
            }
        }
        return bug;
    }

    static List<MapdustBug> buildMapdustBugList(MapdustGetBugsResponse bugsResponse) {
        MapdustBugContent[] bugContent;
        ArrayList<MapdustBug> bugsList = new ArrayList<MapdustBug>();
        if (bugsResponse != null && (bugContent = bugsResponse.getFeatures()) != null) {
            for (MapdustBugContent obj : bugContent) {
                MapdustBug bug = MapdustConverter.buildMapdustBug(obj);
                bugsList.add(bug);
            }
        }
        return bugsList;
    }

    private static MapdustBug buildMapdustBug(MapdustBugContent bugContent) {
        MapdustBug bug = new MapdustBug();
        if (bugContent != null) {
            bug.setId(bugContent.getId());
            Geometry geometry = bugContent.getGeometry();
            LatLon latLon = null;
            if (geometry != null && geometry.getCoordinates() != null && geometry.getCoordinates().length == 2) {
                Double longitude = geometry.getCoordinates()[0];
                Double latitude = geometry.getCoordinates()[1];
                latLon = new LatLon(latitude.doubleValue(), longitude.doubleValue());
            }
            bug.setLatLon(latLon);
            MapdustBugProperties bugProperties = bugContent.getProperties();
            if (bugProperties != null) {
                bug.setAddress(bugProperties.getAddress());
                Status status = Status.getStatus(bugProperties.getStatus());
                bug.setStatus(status);
                BugType type = BugType.getType(bugProperties.getType());
                bug.setType(type);
                MapdustRelevance relevance = MapdustRelevance.getMapdustRelevance(bugProperties.getRelevance());
                bug.setRelevance(relevance);
                bug.setDateCreated(bugProperties.getDateCreated());
                bug.setDateUpdated(bugProperties.getDateUpdated());
                bug.setDescription(bugProperties.getDescription());
                bug.setSkoUid(bugProperties.getSkoUid());
                bug.setExtUid(bugProperties.getExtUid());
                bug.setNickname(bugProperties.getNickname());
                bug.setSource(bugProperties.getSource());
                bug.setKmlUrl(bugProperties.getKmlUrl());
                bug.setNumberOfComments(bugProperties.getNumberOfComments());
                MapdustCommentProperties[] commentProperties = bugProperties.getComments();
                MapdustComment[] commentArray = MapdustConverter.buildMapdustCommentArray(bug.getId(), commentProperties);
                bug.setComments(commentArray);
            }
        }
        return bug;
    }

    private static MapdustComment buildMapdustComment(Long bugId, MapdustCommentProperties commentProperties) {
        MapdustComment comment = new MapdustComment();
        if (bugId != null) {
            comment.setBugId(bugId);
        }
        if (commentProperties != null) {
            comment.setDateCreated(commentProperties.getDateCreated());
            comment.setCommentText(commentProperties.getComment());
            comment.setExtUid(commentProperties.getExtUid());
            comment.setNickname(commentProperties.getNickname());
            comment.setSkoUid(commentProperties.getSkoUid());
            comment.setSource(commentProperties.getSource());
        }
        return comment;
    }

    private static MapdustComment[] buildMapdustCommentArray(Long bugId, MapdustCommentProperties[] commentProperties) {
        ArrayList<MapdustComment> commentList = new ArrayList<MapdustComment>();
        if (bugId != null && commentProperties != null) {
            for (MapdustCommentProperties obj : commentProperties) {
                MapdustComment comment = MapdustConverter.buildMapdustComment(bugId, obj);
                commentList.add(comment);
            }
        }
        MapdustComment[] commentArray = commentList.toArray(new MapdustComment[0]);
        return commentArray;
    }
}

