/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.mult;

import org.ejml.data.CD1Matrix64F;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.ops.CCommonOps;
import org.ejml.ops.MatrixDimensionException;

public class CMatrixMatrixMult {
    public static void mult_reorder(CDenseMatrix64F a, CDenseMatrix64F b, CDenseMatrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a.numCols == 0 || a.numRows == 0) {
            CCommonOps.fill((CD1Matrix64F)c, 0.0, 0.0);
            return;
        }
        int indexCbase = 0;
        int strideA = a.getRowStride();
        int strideB = b.getRowStride();
        int strideC = c.getRowStride();
        int endOfKLoop = b.numRows * strideB;
        for (int i = 0; i < a.numRows; ++i) {
            double imgB;
            double realB;
            int indexA = i * strideA;
            int indexB = 0;
            int indexC = indexCbase;
            int end = indexB + strideB;
            double realA = a.data[indexA++];
            double imgA = a.data[indexA++];
            while (indexB < end) {
                realB = b.data[indexB++];
                imgB = b.data[indexB++];
                c.data[indexC++] = realA * realB - imgA * imgB;
                c.data[indexC++] = realA * imgB + imgA * realB;
            }
            while (indexB != endOfKLoop) {
                indexC = indexCbase;
                end = indexB + strideB;
                realA = a.data[indexA++];
                imgA = a.data[indexA++];
                while (indexB < end) {
                    realB = b.data[indexB++];
                    imgB = b.data[indexB++];
                    int n = indexC++;
                    c.data[n] = c.data[n] + (realA * realB - imgA * imgB);
                    int n2 = indexC++;
                    c.data[n2] = c.data[n2] + (realA * imgB + imgA * realB);
                }
            }
            indexCbase += strideC;
        }
    }

    public static void mult_small(CDenseMatrix64F a, CDenseMatrix64F b, CDenseMatrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int aIndexStart = 0;
        int cIndex = 0;
        int strideA = a.getRowStride();
        int strideB = b.getRowStride();
        for (int i = 0; i < a.numRows; ++i) {
            for (int j = 0; j < b.numCols; ++j) {
                double realTotal = 0.0;
                double imgTotal = 0.0;
                int indexA = aIndexStart;
                int indexB = j * 2;
                int end = indexA + strideA;
                while (indexA < end) {
                    double realA = a.data[indexA++];
                    double imgA = a.data[indexA++];
                    double realB = b.data[indexB];
                    double imgB = b.data[indexB + 1];
                    realTotal += realA * realB - imgA * imgB;
                    imgTotal += realA * imgB + imgA * realB;
                    indexB += strideB;
                }
                c.data[cIndex++] = realTotal;
                c.data[cIndex++] = imgTotal;
            }
            aIndexStart += strideA;
        }
    }

    public static void multAdd_reorder(CDenseMatrix64F a, CDenseMatrix64F b, CDenseMatrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a.numCols == 0 || a.numRows == 0) {
            return;
        }
        int indexCbase = 0;
        int strideA = a.getRowStride();
        int strideB = b.getRowStride();
        int strideC = c.getRowStride();
        int endOfKLoop = b.numRows * strideB;
        for (int i = 0; i < a.numRows; ++i) {
            double imgB;
            double realB;
            int indexA = i * strideA;
            int indexB = 0;
            int indexC = indexCbase;
            int end = indexB + strideB;
            double realA = a.data[indexA++];
            double imgA = a.data[indexA++];
            while (indexB < end) {
                realB = b.data[indexB++];
                imgB = b.data[indexB++];
                int n = indexC++;
                c.data[n] = c.data[n] + (realA * realB - imgA * imgB);
                int n2 = indexC++;
                c.data[n2] = c.data[n2] + (realA * imgB + imgA * realB);
            }
            while (indexB != endOfKLoop) {
                indexC = indexCbase;
                end = indexB + strideB;
                realA = a.data[indexA++];
                imgA = a.data[indexA++];
                while (indexB < end) {
                    realB = b.data[indexB++];
                    imgB = b.data[indexB++];
                    int n = indexC++;
                    c.data[n] = c.data[n] + (realA * realB - imgA * imgB);
                    int n3 = indexC++;
                    c.data[n3] = c.data[n3] + (realA * imgB + imgA * realB);
                }
            }
            indexCbase += strideC;
        }
    }

    public static void multAdd_small(CDenseMatrix64F a, CDenseMatrix64F b, CDenseMatrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int aIndexStart = 0;
        int cIndex = 0;
        int strideA = a.getRowStride();
        int strideB = b.getRowStride();
        for (int i = 0; i < a.numRows; ++i) {
            for (int j = 0; j < b.numCols; ++j) {
                double realTotal = 0.0;
                double imgTotal = 0.0;
                int indexA = aIndexStart;
                int indexB = j * 2;
                int end = indexA + strideA;
                while (indexA < end) {
                    double realA = a.data[indexA++];
                    double imgA = a.data[indexA++];
                    double realB = b.data[indexB];
                    double imgB = b.data[indexB + 1];
                    realTotal += realA * realB - imgA * imgB;
                    imgTotal += realA * imgB + imgA * realB;
                    indexB += strideB;
                }
                int n = cIndex++;
                c.data[n] = c.data[n] + realTotal;
                int n2 = cIndex++;
                c.data[n2] = c.data[n2] + imgTotal;
            }
            aIndexStart += strideA;
        }
    }

    public static void mult_reorder(double realAlpha, double imgAlpha, CDenseMatrix64F a, CDenseMatrix64F b, CDenseMatrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a.numCols == 0 || a.numRows == 0) {
            CCommonOps.fill((CD1Matrix64F)c, 0.0, 0.0);
            return;
        }
        int indexCbase = 0;
        int strideA = a.getRowStride();
        int strideB = b.getRowStride();
        int strideC = c.getRowStride();
        int endOfKLoop = b.numRows * strideB;
        for (int i = 0; i < a.numRows; ++i) {
            double imgB;
            double realB;
            int indexA = i * strideA;
            int indexB = 0;
            int indexC = indexCbase;
            int end = indexB + strideB;
            double realTmp = a.data[indexA++];
            double imgTmp = a.data[indexA++];
            double realA = realAlpha * realTmp - imgAlpha * imgTmp;
            double imgA = realAlpha * imgTmp + imgAlpha * realTmp;
            while (indexB < end) {
                realB = b.data[indexB++];
                imgB = b.data[indexB++];
                c.data[indexC++] = realA * realB - imgA * imgB;
                c.data[indexC++] = realA * imgB + imgA * realB;
            }
            while (indexB != endOfKLoop) {
                indexC = indexCbase;
                end = indexB + strideB;
                realTmp = a.data[indexA++];
                imgTmp = a.data[indexA++];
                realA = realAlpha * realTmp - imgAlpha * imgTmp;
                imgA = realAlpha * imgTmp + imgAlpha * realTmp;
                while (indexB < end) {
                    realB = b.data[indexB++];
                    imgB = b.data[indexB++];
                    int n = indexC++;
                    c.data[n] = c.data[n] + (realA * realB - imgA * imgB);
                    int n2 = indexC++;
                    c.data[n2] = c.data[n2] + (realA * imgB + imgA * realB);
                }
            }
            indexCbase += strideC;
        }
    }

    public static void mult_small(double realAlpha, double imgAlpha, CDenseMatrix64F a, CDenseMatrix64F b, CDenseMatrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int aIndexStart = 0;
        int cIndex = 0;
        int strideA = a.getRowStride();
        int strideB = b.getRowStride();
        for (int i = 0; i < a.numRows; ++i) {
            for (int j = 0; j < b.numCols; ++j) {
                double realTotal = 0.0;
                double imgTotal = 0.0;
                int indexA = aIndexStart;
                int indexB = j * 2;
                int end = indexA + strideA;
                while (indexA < end) {
                    double realA = a.data[indexA++];
                    double imgA = a.data[indexA++];
                    double realB = b.data[indexB];
                    double imgB = b.data[indexB + 1];
                    realTotal += realA * realB - imgA * imgB;
                    imgTotal += realA * imgB + imgA * realB;
                    indexB += strideB;
                }
                c.data[cIndex++] = realAlpha * realTotal - imgAlpha * imgTotal;
                c.data[cIndex++] = realAlpha * imgTotal + imgAlpha * realTotal;
            }
            aIndexStart += strideA;
        }
    }

    public static void multAdd_reorder(double realAlpha, double imgAlpha, CDenseMatrix64F a, CDenseMatrix64F b, CDenseMatrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a.numCols == 0 || a.numRows == 0) {
            return;
        }
        int indexCbase = 0;
        int strideA = a.getRowStride();
        int strideB = b.getRowStride();
        int strideC = c.getRowStride();
        int endOfKLoop = b.numRows * strideB;
        for (int i = 0; i < a.numRows; ++i) {
            double imgB;
            double realB;
            int indexA = i * strideA;
            int indexB = 0;
            int indexC = indexCbase;
            int end = indexB + strideB;
            double realTmp = a.data[indexA++];
            double imgTmp = a.data[indexA++];
            double realA = realAlpha * realTmp - imgAlpha * imgTmp;
            double imgA = realAlpha * imgTmp + imgAlpha * realTmp;
            while (indexB < end) {
                realB = b.data[indexB++];
                imgB = b.data[indexB++];
                int n = indexC++;
                c.data[n] = c.data[n] + (realA * realB - imgA * imgB);
                int n2 = indexC++;
                c.data[n2] = c.data[n2] + (realA * imgB + imgA * realB);
            }
            while (indexB != endOfKLoop) {
                indexC = indexCbase;
                end = indexB + strideB;
                realTmp = a.data[indexA++];
                imgTmp = a.data[indexA++];
                realA = realAlpha * realTmp - imgAlpha * imgTmp;
                imgA = realAlpha * imgTmp + imgAlpha * realTmp;
                while (indexB < end) {
                    realB = b.data[indexB++];
                    imgB = b.data[indexB++];
                    int n = indexC++;
                    c.data[n] = c.data[n] + (realA * realB - imgA * imgB);
                    int n3 = indexC++;
                    c.data[n3] = c.data[n3] + (realA * imgB + imgA * realB);
                }
            }
            indexCbase += strideC;
        }
    }

    public static void multAdd_small(double realAlpha, double imgAlpha, CDenseMatrix64F a, CDenseMatrix64F b, CDenseMatrix64F c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int aIndexStart = 0;
        int cIndex = 0;
        int strideA = a.getRowStride();
        int strideB = b.getRowStride();
        for (int i = 0; i < a.numRows; ++i) {
            for (int j = 0; j < b.numCols; ++j) {
                double realTotal = 0.0;
                double imgTotal = 0.0;
                int indexA = aIndexStart;
                int indexB = j * 2;
                int end = indexA + strideA;
                while (indexA < end) {
                    double realA = a.data[indexA++];
                    double imgA = a.data[indexA++];
                    double realB = b.data[indexB];
                    double imgB = b.data[indexB + 1];
                    realTotal += realA * realB - imgA * imgB;
                    imgTotal += realA * imgB + imgA * realB;
                    indexB += strideB;
                }
                int n = cIndex++;
                c.data[n] = c.data[n] + (realAlpha * realTotal - imgAlpha * imgTotal);
                int n2 = cIndex++;
                c.data[n2] = c.data[n2] + (realAlpha * imgTotal + imgAlpha * realTotal);
            }
            aIndexStart += strideA;
        }
    }
}

