/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.factory;

import org.ejml.EjmlParameters;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionBlock_D64;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionInner_D64;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionLDL_D64;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecomposition_B64_to_D64;
import org.ejml.alg.dense.decomposition.eig.SwitchingEigenDecomposition;
import org.ejml.alg.dense.decomposition.eig.SymmetricQRAlgorithmDecomposition_D64;
import org.ejml.alg.dense.decomposition.eig.WatchedDoubleStepQRDecomposition_D64;
import org.ejml.alg.dense.decomposition.hessenberg.TridiagonalDecompositionHouseholder_D64;
import org.ejml.alg.dense.decomposition.hessenberg.TridiagonalDecomposition_B64_to_D64;
import org.ejml.alg.dense.decomposition.lu.LUDecompositionAlt_D64;
import org.ejml.alg.dense.decomposition.qr.QRColPivDecompositionHouseholderColumn_D64;
import org.ejml.alg.dense.decomposition.qr.QRDecompositionHouseholderColumn_D64;
import org.ejml.alg.dense.decomposition.svd.SvdImplicitQrDecompose_D64;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.RealMatrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.interfaces.decomposition.CholeskyDecomposition;
import org.ejml.interfaces.decomposition.CholeskyLDLDecomposition;
import org.ejml.interfaces.decomposition.DecompositionInterface;
import org.ejml.interfaces.decomposition.EigenDecomposition;
import org.ejml.interfaces.decomposition.LUDecomposition;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.interfaces.decomposition.QRPDecomposition;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.interfaces.decomposition.TridiagonalSimilarDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.ops.EigenOps;
import org.ejml.ops.NormOps;
import org.ejml.ops.SpecializedOps;

public class DecompositionFactory {
    public static CholeskyDecomposition<DenseMatrix64F> chol(int matrixSize, boolean lower) {
        if (matrixSize < EjmlParameters.SWITCH_BLOCK64_CHOLESKY) {
            return new CholeskyDecompositionInner_D64(lower);
        }
        if (EjmlParameters.MEMORY == EjmlParameters.MemoryUsage.FASTER) {
            return new CholeskyDecomposition_B64_to_D64(lower);
        }
        return new CholeskyDecompositionBlock_D64(EjmlParameters.BLOCK_WIDTH_CHOL);
    }

    public static CholeskyLDLDecomposition<DenseMatrix64F> cholLDL(int matrixSize) {
        return new CholeskyDecompositionLDL_D64();
    }

    public static LUDecomposition<DenseMatrix64F> lu(int numRows, int numCol) {
        return new LUDecompositionAlt_D64();
    }

    public static SingularValueDecomposition<DenseMatrix64F> svd(int numRows, int numCols, boolean needU, boolean needV, boolean compact) {
        return new SvdImplicitQrDecompose_D64(compact, needU, needV, false);
    }

    public static QRDecomposition<DenseMatrix64F> qr(int numRows, int numCols) {
        return new QRDecompositionHouseholderColumn_D64();
    }

    public static QRPDecomposition<DenseMatrix64F> qrp(int numRows, int numCols) {
        return new QRColPivDecompositionHouseholderColumn_D64();
    }

    public static EigenDecomposition<DenseMatrix64F> eig(int matrixSize, boolean needVectors) {
        return new SwitchingEigenDecomposition(matrixSize, needVectors, 1.0E-8);
    }

    public static EigenDecomposition<DenseMatrix64F> eig(int matrixSize, boolean computeVectors, boolean isSymmetric) {
        if (isSymmetric) {
            TridiagonalSimilarDecomposition<DenseMatrix64F> decomp = DecompositionFactory.tridiagonal(matrixSize);
            return new SymmetricQRAlgorithmDecomposition_D64(decomp, computeVectors);
        }
        return new WatchedDoubleStepQRDecomposition_D64(computeVectors);
    }

    public static double quality(DenseMatrix64F orig, SingularValueDecomposition<DenseMatrix64F> svd) {
        return DecompositionFactory.quality(orig, (DenseMatrix64F)svd.getU(null, false), (DenseMatrix64F)svd.getW(null), (DenseMatrix64F)svd.getV(null, true));
    }

    public static double quality(DenseMatrix64F orig, DenseMatrix64F U, DenseMatrix64F W, DenseMatrix64F Vt) {
        DenseMatrix64F UW = new DenseMatrix64F(U.numRows, W.numCols);
        CommonOps.mult((RowD1Matrix64F)U, (RowD1Matrix64F)W, (RowD1Matrix64F)UW);
        DenseMatrix64F foundA = new DenseMatrix64F(UW.numRows, Vt.numCols);
        CommonOps.mult((RowD1Matrix64F)UW, (RowD1Matrix64F)Vt, (RowD1Matrix64F)foundA);
        double normA = NormOps.normF((D1Matrix64F)foundA);
        return SpecializedOps.diffNormF((D1Matrix64F)orig, (D1Matrix64F)foundA) / normA;
    }

    public static double quality(DenseMatrix64F orig, EigenDecomposition<DenseMatrix64F> eig) {
        DenseMatrix64F A = orig;
        DenseMatrix64F V = EigenOps.createMatrixV(eig);
        DenseMatrix64F D = EigenOps.createMatrixD(eig);
        DenseMatrix64F L = new DenseMatrix64F(A.numRows, V.numCols);
        CommonOps.mult((RowD1Matrix64F)A, (RowD1Matrix64F)V, (RowD1Matrix64F)L);
        DenseMatrix64F R = new DenseMatrix64F(V.numRows, D.numCols);
        CommonOps.mult((RowD1Matrix64F)V, (RowD1Matrix64F)D, (RowD1Matrix64F)R);
        DenseMatrix64F diff = new DenseMatrix64F(L.numRows, L.numCols);
        CommonOps.subtract((D1Matrix64F)L, (D1Matrix64F)R, (D1Matrix64F)diff);
        double top = NormOps.normF((D1Matrix64F)diff);
        double bottom = NormOps.normF((D1Matrix64F)L);
        double error = top / bottom;
        return error;
    }

    public static TridiagonalSimilarDecomposition<DenseMatrix64F> tridiagonal(int matrixSize) {
        if (matrixSize >= 1800) {
            return new TridiagonalDecomposition_B64_to_D64();
        }
        return new TridiagonalDecompositionHouseholder_D64();
    }

    public static <T extends RealMatrix64F> boolean decomposeSafe(DecompositionInterface<T> decomp, T M) {
        if (decomp.inputModified()) {
            return decomp.decompose(M.copy());
        }
        return decomp.decompose(M);
    }
}

