/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.simple;

import org.ejml.UtilEjml;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.SingularOps;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;

public class SimpleSVD<T extends SimpleMatrix> {
    private SingularValueDecomposition<DenseMatrix64F> svd;
    private T U;
    private T W;
    private T V;
    private DenseMatrix64F mat;
    double tol;

    public SimpleSVD(DenseMatrix64F mat, boolean compact) {
        this.mat = mat;
        this.svd = DecompositionFactory.svd((int)mat.numRows, (int)mat.numCols, (boolean)true, (boolean)true, (boolean)compact);
        if (!this.svd.decompose((Matrix)mat)) {
            throw new RuntimeException("Decomposition failed");
        }
        this.U = SimpleMatrix.wrap((DenseMatrix64F)this.svd.getU(null, false));
        this.W = SimpleMatrix.wrap((DenseMatrix64F)this.svd.getW(null));
        this.V = SimpleMatrix.wrap((DenseMatrix64F)this.svd.getV(null, false));
        SingularOps.descendingOrder((DenseMatrix64F)((SimpleBase)this.U).getMatrix(), (boolean)false, (DenseMatrix64F)((SimpleBase)this.W).getMatrix(), (DenseMatrix64F)((SimpleBase)this.V).getMatrix(), (boolean)false);
        this.tol = SingularOps.singularThreshold(this.svd);
    }

    public T getU() {
        return this.U;
    }

    public T getW() {
        return this.W;
    }

    public T getV() {
        return this.V;
    }

    public double quality() {
        return DecompositionFactory.quality((DenseMatrix64F)this.mat, (DenseMatrix64F)((SimpleBase)this.U).getMatrix(), (DenseMatrix64F)((SimpleBase)this.W).getMatrix(), (DenseMatrix64F)((SimpleMatrix)((SimpleBase)this.V).transpose()).getMatrix());
    }

    public SimpleMatrix nullSpace() {
        return SimpleMatrix.wrap(SingularOps.nullSpace(this.svd, null, (double)this.tol));
    }

    public double getSingleValue(int index) {
        return ((SimpleBase)this.W).get(index, index);
    }

    public int rank() {
        return SingularOps.rank(this.svd, (double)this.tol);
    }

    public int nullity() {
        return SingularOps.nullity(this.svd, (double)(10.0 * UtilEjml.EPS));
    }

    public SingularValueDecomposition getSVD() {
        return this.svd;
    }
}

