/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.Mercator;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;

public class Mercator2SP
extends Mercator {
    private static final long serialVersionUID = -5693375873386007245L;

    protected Mercator2SP(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = 6356028352681135786L;
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Mercator_2SP"), new NamedIdentifier(Citations.EPSG, "Mercator (2SP)"), new NamedIdentifier(Citations.EPSG, "Mercator (variant B)"), new NamedIdentifier(Citations.EPSG, "Mercator (variant C)"), new NamedIdentifier(Citations.EPSG, "1044"), new NamedIdentifier(Citations.EPSG, "9805"), new NamedIdentifier(Citations.GEOTIFF, "CT_Mercator"), new NamedIdentifier(Citations.ESRI, "Mercator"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(34))}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, STANDARD_PARALLEL_1, LATITUDE_OF_ORIGIN, CENTRAL_MERIDIAN, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        public Class<CylindricalProjection> getOperationType() {
            return CylindricalProjection.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            if (Provider.isSpherical(parameters)) {
                return new Spherical(parameters);
            }
            return new Mercator2SP(parameters);
        }
    }

    private static final class Spherical
    extends Mercator.Spherical {
        private static final long serialVersionUID = 7693484746681095374L;

        protected Spherical(ParameterValueGroup parameters) throws ParameterNotFoundException {
            super(parameters);
        }

        @Override
        public ParameterDescriptorGroup getParameterDescriptors() {
            return Provider.PARAMETERS;
        }
    }
}

