/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.crs.ForceCoordinateSystemFeatureResults;
import org.geotools.data.crs.ReprojectFeatureIterator;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.feature.collection.AbstractFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;

public class ReprojectFeatureResults
extends AbstractFeatureCollection {
    FeatureCollection<SimpleFeatureType, SimpleFeature> results;
    MathTransform transform;

    public ReprojectFeatureResults(FeatureCollection<SimpleFeatureType, SimpleFeature> results, CoordinateReferenceSystem destinationCS) throws IOException, SchemaException, TransformException, OperationNotFoundException, NoSuchElementException, FactoryException {
        super(ReprojectFeatureResults.forceType(ReprojectFeatureResults.origionalType(results), destinationCS));
        this.results = ReprojectFeatureResults.origionalCollection(results);
        CoordinateReferenceSystem originalCs = null;
        originalCs = results instanceof ForceCoordinateSystemFeatureResults ? results.getSchema().getGeometryDescriptor().getCoordinateReferenceSystem() : this.results.getSchema().getGeometryDescriptor().getCoordinateReferenceSystem();
        this.transform = CRS.findMathTransform(originalCs, destinationCS, true);
    }

    public Iterator openIterator() {
        return new ReprojectFeatureIterator(this.results.features(), this.getSchema(), this.transform);
    }

    public void closeIterator(Iterator close) {
        if (close == null) {
            return;
        }
        if (close instanceof ReprojectFeatureIterator) {
            ReprojectFeatureIterator iterator = (ReprojectFeatureIterator)close;
            iterator.close();
        }
    }

    @Override
    public int size() {
        return this.results.size();
    }

    private static FeatureCollection<SimpleFeatureType, SimpleFeature> origionalCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> results) {
        if (results instanceof ReprojectFeatureResults) {
            results = ((ReprojectFeatureResults)results).getOrigin();
        }
        if (results instanceof ForceCoordinateSystemFeatureResults) {
            results = ((ForceCoordinateSystemFeatureResults)results).getOrigin();
        }
        return results;
    }

    private static SimpleFeatureType origionalType(FeatureCollection<SimpleFeatureType, SimpleFeature> results) {
        if (results instanceof ReprojectFeatureResults) {
            results = ((ReprojectFeatureResults)results).getOrigin();
        }
        if (results instanceof ForceCoordinateSystemFeatureResults) {
            results = ((ForceCoordinateSystemFeatureResults)results).getOrigin();
        }
        return results.getSchema();
    }

    private static SimpleFeatureType forceType(SimpleFeatureType startingType, CoordinateReferenceSystem forcedCS) throws SchemaException {
        if (forcedCS == null) {
            throw new NullPointerException("CoordinateSystem required");
        }
        CoordinateReferenceSystem originalCs = startingType.getGeometryDescriptor().getCoordinateReferenceSystem();
        if (forcedCS.equals(originalCs)) {
            return startingType;
        }
        return FeatureTypes.transform(startingType, forcedCS);
    }

    @Override
    public ReferencedEnvelope getBounds() {
        try (SimpleFeatureIterator r = this.features();){
            Envelope newBBox = new Envelope();
            while (r.hasNext()) {
                SimpleFeature feature = (SimpleFeature)r.next();
                Geometry geometry = (Geometry)feature.getDefaultGeometry();
                if (geometry == null) continue;
                Envelope internal = geometry.getEnvelopeInternal();
                newBBox.expandToInclude(internal);
            }
            ReferencedEnvelope referencedEnvelope = ReferencedEnvelope.reference(newBBox);
            return referencedEnvelope;
        }
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> getOrigin() {
        return this.results;
    }
}

