/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.algebra.AlgebraDescriptor;
import java.awt.image.RenderedImage;
import java.util.Collection;
import java.util.Map;
import javax.media.jai.ParameterBlockJAI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.BaseMathOperationJAI;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.util.NumberRange;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.InternationalString;

public class Log
extends BaseMathOperationJAI {
    private static final long serialVersionUID = -3622176942444895367L;

    public Log() {
        super("Log", Log.getOperationDescriptor(JAIExt.getOperationName((String)"Log")));
    }

    @Override
    public String getName() {
        return "Log";
    }

    @Override
    protected NumberRange deriveRange(NumberRange[] ranges, OperationJAI.Parameters parameters) {
        NumberRange range = ranges[0];
        double min = Math.log(range.getMinimum());
        double max = Math.log(range.getMaximum());
        return NumberRange.create(min, max);
    }

    @Override
    protected void handleJAIEXTParams(ParameterBlockJAI parameters, ParameterValueGroup parameters2) {
        if (JAIExt.isJAIExtOperation((String)"algebric")) {
            parameters.set((Object)AlgebraDescriptor.Operator.LOG, 0);
            Collection sources = (Collection)parameters2.parameter("sources").getValue();
            for (GridCoverage2D source : sources) {
                Log.handleROINoDataInternal(parameters, source, "algebric", 1, 2);
            }
        }
    }

    @Override
    protected Map<String, ?> getProperties(RenderedImage data, CoordinateReferenceSystem crs, InternationalString name, MathTransform gridToCRS, GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        return Log.handleROINoDataProperties(null, parameters.parameters, sources[0], "algebric", 1, 2, 3);
    }
}

