/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.events;

public enum MediaPlayerEventType {
    MEDIA_CHANGED(1),
    OPENING(2),
    BUFFERING(4),
    PLAYING(8),
    PAUSED(16),
    STOPPED(32),
    FORWARD(64),
    BACKWARD(128),
    FINISHED(256),
    TIME_CHANGED(512),
    POSITION_CHANGED(1024),
    SEEKABLE_CHANGED(2048),
    PAUSABLE_CHANGED(4096),
    TITLE_CHANGED(8192),
    SNAPSHOT_TAKEN(16384),
    LENGTH_CHANGED(32768),
    VIDEO_OUTPUT(65536),
    SCRAMBLED_CHANGED(131072),
    ES_ADDED(262144),
    ES_DELETED(524288),
    ES_SELECTED(0x100000),
    ERROR(0x200000),
    MEDIA_META_CHANGED(0x400000),
    MEDIA_SUB_ITEM_ADDED(0x800000),
    MEDIA_DURATION_CHANGED(0x1000000),
    MEDIA_PARSED_CHANGED(0x2000000),
    MEDIA_FREED(0x4000000),
    MEDIA_STATE_CHANGED(0x8000000),
    NEW_MEDIA(0x10000000),
    SUB_ITEM_PLAYED(0x20000000),
    SUB_ITEM_FINISHED(0x40000000),
    END_OF_SUB_ITEMS(Integer.MIN_VALUE),
    ALL(-1);

    private int value;

    private MediaPlayerEventType(int value) {
        this.value = value;
    }

    public final int value() {
        return this.value;
    }

    public static int events(MediaPlayerEventType ... types) {
        int eventMask = 0;
        for (MediaPlayerEventType type : types) {
            eventMask |= type.value();
        }
        return eventMask;
    }

    public static int notEvents(MediaPlayerEventType ... types) {
        int eventMask = MediaPlayerEventType.ALL.value;
        for (MediaPlayerEventType type : types) {
            eventMask &= ~type.value();
        }
        return eventMask;
    }

    public static boolean set(int value, MediaPlayerEventType type) {
        return (value & type.value()) != 0;
    }

    public static boolean notSet(int value, MediaPlayerEventType type) {
        return (value & type.value()) == 0;
    }
}

