/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.medialist.events;

import uk.co.caprica.vlcj.binding.internal.libvlc_event_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_t;
import uk.co.caprica.vlcj.binding.internal.media_list_item_added;
import uk.co.caprica.vlcj.binding.internal.media_list_item_deleted;
import uk.co.caprica.vlcj.binding.internal.media_list_will_add_item;
import uk.co.caprica.vlcj.binding.internal.media_list_will_delete_item;
import uk.co.caprica.vlcj.medialist.MediaList;
import uk.co.caprica.vlcj.medialist.events.AbstractMediaListEvent;
import uk.co.caprica.vlcj.medialist.events.MediaListEvent;
import uk.co.caprica.vlcj.medialist.events.MediaListItemAddedEvent;
import uk.co.caprica.vlcj.medialist.events.MediaListItemDeletedEvent;
import uk.co.caprica.vlcj.medialist.events.MediaListWillAddItemEvent;
import uk.co.caprica.vlcj.medialist.events.MediaListWillDeleteItemEvent;

public class MediaListEventFactory {
    private final MediaList mediaList;

    public MediaListEventFactory(MediaList mediaList) {
        this.mediaList = mediaList;
    }

    public MediaListEvent createEvent(libvlc_event_t event) {
        AbstractMediaListEvent result = null;
        switch (libvlc_event_e.event(event.type)) {
            case libvlc_MediaListWillAddItem: {
                media_list_will_add_item addItemEvent = (media_list_will_add_item)((Object)event.u.getTypedValue(media_list_will_add_item.class));
                result = new MediaListWillAddItemEvent(this.mediaList, addItemEvent.item, addItemEvent.index);
                break;
            }
            case libvlc_MediaListItemAdded: {
                media_list_item_added itemAddedEvent = (media_list_item_added)((Object)event.u.getTypedValue(media_list_item_added.class));
                result = new MediaListItemAddedEvent(this.mediaList, itemAddedEvent.item, itemAddedEvent.index);
                break;
            }
            case libvlc_MediaListWillDeleteItem: {
                media_list_will_delete_item deleteItemEvent = (media_list_will_delete_item)((Object)event.u.getTypedValue(media_list_will_delete_item.class));
                result = new MediaListWillDeleteItemEvent(this.mediaList, deleteItemEvent.item, deleteItemEvent.index);
                break;
            }
            case libvlc_MediaListItemDeleted: {
                media_list_item_deleted itemDeletedEvent = (media_list_item_deleted)((Object)event.u.getTypedValue(media_list_item_deleted.class));
                result = new MediaListItemDeletedEvent(this.mediaList, itemDeletedEvent.item, itemDeletedEvent.index);
            }
        }
        return result;
    }
}

