/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;

public class AbbreviationAsWordInNameCheck
extends Check {
    public static final String MSG_KEY = "abbreviation.as.word";
    private static final int DEFAULT_ALLOWED_ABBREVIATIONS_LENGTH = 3;
    private int allowedAbbreviationLength = 3;
    private Set<String> allowedAbbreviations = new HashSet<String>();
    private boolean ignoreFinal = true;
    private boolean ignoreStatic = true;
    private boolean ignoreOverriddenMethods = true;

    public void setIgnoreFinal(boolean ignoreFinal) {
        this.ignoreFinal = ignoreFinal;
    }

    public void setIgnoreStatic(boolean ignoreStatic) {
        this.ignoreStatic = ignoreStatic;
    }

    public void setIgnoreOverriddenMethods(boolean ignoreOverriddenMethods) {
        this.ignoreOverriddenMethods = ignoreOverriddenMethods;
    }

    public void setAllowedAbbreviationLength(int allowedAbbreviationLength) {
        this.allowedAbbreviationLength = allowedAbbreviationLength;
    }

    public void setAllowedAbbreviations(String allowedAbbreviations) {
        if (allowedAbbreviations != null) {
            this.allowedAbbreviations = new HashSet<String>(Arrays.asList(allowedAbbreviations.split(",")));
        }
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{14, 15, 154, 157, 161, 21, 10, 9};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{14, 15, 154, 157, 161, 21, 10, 9, 155};
    }

    @Override
    public int[] getRequiredTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST nameAst;
        String typeName;
        String abbr;
        if (!this.isIgnoreSituation(ast) && (abbr = this.getDisallowedAbbreviation(typeName = (nameAst = ast.findFirstToken(58)).getText())) != null) {
            this.log(nameAst.getLineNo(), MSG_KEY, this.allowedAbbreviationLength);
        }
    }

    private boolean isIgnoreSituation(DetailAST ast) {
        DetailAST modifiers = ast.getFirstChild();
        boolean result = false;
        if (ast.getType() == 10) {
            result = (this.ignoreFinal || this.ignoreStatic) && AbbreviationAsWordInNameCheck.isInterfaceDeclaration(ast) ? true : this.ignoreFinal && modifiers.branchContains(39) || this.ignoreStatic && modifiers.branchContains(64);
        } else if (ast.getType() == 9) {
            result = this.ignoreOverriddenMethods && AbbreviationAsWordInNameCheck.hasOverrideAnnotation(modifiers);
        }
        return result;
    }

    private static boolean isInterfaceDeclaration(DetailAST variableDefAst) {
        boolean result = false;
        DetailAST astBlock = variableDefAst.getParent();
        DetailAST astParent2 = astBlock.getParent();
        if (astParent2.getType() == 15) {
            result = true;
        }
        return result;
    }

    private static boolean hasOverrideAnnotation(DetailAST methodModifiersAST) {
        boolean result = false;
        for (DetailAST child : AbbreviationAsWordInNameCheck.getChildren(methodModifiersAST)) {
            DetailAST annotationIdent;
            if (child.getType() != 159 || (annotationIdent = child.findFirstToken(58)) == null || !"Override".equals(annotationIdent.getText())) continue;
            result = true;
            break;
        }
        return result;
    }

    private String getDisallowedAbbreviation(String str) {
        int beginIndex = 0;
        boolean abbrStarted = false;
        String result = null;
        for (int index = 0; index < str.length(); ++index) {
            char symbol = str.charAt(index);
            if (Character.isUpperCase(symbol)) {
                if (abbrStarted) continue;
                abbrStarted = true;
                beginIndex = index;
                continue;
            }
            if (!abbrStarted) continue;
            abbrStarted = false;
            int endIndex = index - 1;
            result = this.getAbbreviationIfIllegal(str, beginIndex, endIndex);
            if (result != null) break;
            beginIndex = -1;
        }
        if (abbrStarted && beginIndex != str.length() - 1) {
            int endIndex = str.length();
            result = this.getAbbreviationIfIllegal(str, beginIndex, endIndex);
        }
        return result;
    }

    private String getAbbreviationIfIllegal(String str, int beginIndex, int endIndex) {
        String abbr;
        String result = null;
        int abbrLength = endIndex - beginIndex;
        if (abbrLength > this.allowedAbbreviationLength && !this.allowedAbbreviations.contains(abbr = str.substring(beginIndex, endIndex))) {
            result = abbr;
        }
        return result;
    }

    private static List<DetailAST> getChildren(DetailAST node) {
        LinkedList<DetailAST> result = new LinkedList<DetailAST>();
        for (DetailAST curNode = node.getFirstChild(); curNode != null; curNode = curNode.getNextSibling()) {
            result.add(curNode);
        }
        return result;
    }
}

