/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.modifier;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class RedundantModifierCheck
extends Check {
    public static final String MSG_KEY = "redundantModifier";
    private static final int[] TOKENS_FOR_INTERFACE_MODIFIERS = new int[]{64, 40};

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9, 10, 161, 15, 8, 14, 154};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getType() == 15) {
            this.checkInterfaceModifiers(ast);
        } else if (ast.getType() == 8) {
            if (RedundantModifierCheck.isEnumMember(ast)) {
                this.checkEnumConstructorModifiers(ast);
            } else {
                this.checkClassConstructorModifiers(ast);
            }
        } else if (ast.getType() == 154) {
            this.checkEnumDef(ast);
        } else if (RedundantModifierCheck.isInterfaceOrAnnotationMember(ast)) {
            this.processInterfaceOrAnnotation(ast);
        } else if (ast.getType() == 9) {
            this.processMethods(ast);
        }
    }

    private void checkInterfaceModifiers(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        for (int tokenType : TOKENS_FOR_INTERFACE_MODIFIERS) {
            DetailAST modifier = modifiers.findFirstToken(tokenType);
            if (modifier == null) continue;
            this.log(modifier.getLineNo(), modifier.getColumnNo(), MSG_KEY, modifier.getText());
        }
    }

    private void checkEnumConstructorModifiers(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        DetailAST modifier = modifiers.getFirstChild();
        if (modifier != null) {
            this.log(modifier.getLineNo(), modifier.getColumnNo(), MSG_KEY, modifier.getText());
        }
    }

    private void checkEnumDef(DetailAST ast) {
        DetailAST modifiers;
        DetailAST staticModifier;
        if (RedundantModifierCheck.isInterfaceOrAnnotationMember(ast)) {
            this.processInterfaceOrAnnotation(ast);
        } else if (ast.getParent() != null && (staticModifier = (modifiers = ast.findFirstToken(5)).findFirstToken(64)) != null) {
            this.log(staticModifier.getLineNo(), staticModifier.getColumnNo(), MSG_KEY, staticModifier.getText());
        }
    }

    private void processInterfaceOrAnnotation(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        for (DetailAST modifier = modifiers.getFirstChild(); modifier != null; modifier = modifier.getNextSibling()) {
            int type = modifier.getType();
            if (!(type == 62 || type == 64 && ast.getType() != 9 || type == 40 && ast.getType() != 14) && (type != 39 || ast.getType() == 14)) continue;
            this.log(modifier.getLineNo(), modifier.getColumnNo(), MSG_KEY, modifier.getText());
            break;
        }
    }

    private void processMethods(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        boolean checkFinal = modifiers.branchContains(61);
        for (DetailAST parent = ast.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getType() != 14) continue;
            DetailAST classModifiers = parent.findFirstToken(5);
            checkFinal |= classModifiers.branchContains(39);
            break;
        }
        if (checkFinal && !RedundantModifierCheck.isAnnotatedWithSafeVarargs(ast)) {
            for (DetailAST modifier = modifiers.getFirstChild(); modifier != null; modifier = modifier.getNextSibling()) {
                int type = modifier.getType();
                if (type != 39) continue;
                this.log(modifier.getLineNo(), modifier.getColumnNo(), MSG_KEY, modifier.getText());
                break;
            }
        }
    }

    private void checkClassConstructorModifiers(DetailAST classCtorAst) {
        DetailAST classDef = classCtorAst.getParent().getParent();
        if (!RedundantModifierCheck.isClassPublic(classDef) && !RedundantModifierCheck.isClassProtected(classDef)) {
            this.checkForRedundantPublicModifier(classCtorAst);
        }
    }

    private void checkForRedundantPublicModifier(DetailAST ast) {
        DetailAST astModifiers = ast.findFirstToken(5);
        for (DetailAST astModifier = astModifiers.getFirstChild(); astModifier != null; astModifier = astModifier.getNextSibling()) {
            if (astModifier.getType() != 62) continue;
            this.log(astModifier.getLineNo(), astModifier.getColumnNo(), MSG_KEY, astModifier.getText());
        }
    }

    private static boolean isClassProtected(DetailAST classDef) {
        DetailAST classModifiers = classDef.findFirstToken(5);
        return classModifiers.branchContains(63);
    }

    private static boolean isClassPublic(DetailAST ast) {
        boolean isAccessibleFromPublic = false;
        boolean isMostOuterScope = ast.getParent() == null;
        DetailAST modifiersAst = ast.findFirstToken(5);
        boolean hasPublicModifier = modifiersAst.branchContains(62);
        if (isMostOuterScope) {
            isAccessibleFromPublic = hasPublicModifier;
        } else {
            DetailAST parentClassAst = ast.getParent().getParent();
            if (parentClassAst.getType() == 15 || hasPublicModifier) {
                isAccessibleFromPublic = RedundantModifierCheck.isClassPublic(parentClassAst);
            }
        }
        return isAccessibleFromPublic;
    }

    private static boolean isEnumMember(DetailAST ast) {
        DetailAST parentTypeDef = ast.getParent().getParent();
        return parentTypeDef.getType() == 154;
    }

    private static boolean isInterfaceOrAnnotationMember(DetailAST ast) {
        DetailAST parentTypeDef = ast.getParent();
        if (parentTypeDef != null) {
            parentTypeDef = parentTypeDef.getParent();
        }
        return parentTypeDef != null && (parentTypeDef.getType() == 15 || parentTypeDef.getType() == 157);
    }

    private static boolean isAnnotatedWithSafeVarargs(DetailAST methodDef) {
        boolean result = false;
        List<DetailAST> methodAnnotationsList = RedundantModifierCheck.getMethodAnnotationsList(methodDef);
        for (DetailAST annotationNode : methodAnnotationsList) {
            if (!"SafeVarargs".equals(annotationNode.getLastChild().getText())) continue;
            result = true;
            break;
        }
        return result;
    }

    private static List<DetailAST> getMethodAnnotationsList(DetailAST methodDef) {
        ArrayList<DetailAST> annotationsList = new ArrayList<DetailAST>();
        DetailAST modifiers = methodDef.findFirstToken(5);
        for (DetailAST modifier = modifiers.getFirstChild(); modifier != null; modifier = modifier.getNextSibling()) {
            if (modifier.getType() != 159) continue;
            annotationsList.add(modifier);
        }
        return annotationsList;
    }
}

