/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.multimap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.SetValuedMap;
import org.apache.commons.collections4.multimap.AbstractListValuedMap;
import org.apache.commons.collections4.multimap.AbstractMultiValuedMap;
import org.apache.commons.collections4.multimap.AbstractSetValuedMap;

public class MultiValuedHashMap<K, V>
extends AbstractMultiValuedMap<K, V> {
    private static final long serialVersionUID = 20150612L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static <K, V> ListValuedMap<K, V> listValuedHashMap() {
        return new ListValuedHashMap(ArrayList.class);
    }

    public static <K, V, C extends List<V>> ListValuedMap<K, V> listValuedHashMap(Class<C> listClass) {
        return new ListValuedHashMap(listClass);
    }

    public static <K, V> SetValuedMap<K, V> setValuedHashMap() {
        return new SetValuedHashMap(HashSet.class);
    }

    public static <K, V, C extends Set<V>> SetValuedMap<K, V> setValuedHashMap(Class<C> setClass) {
        return new SetValuedHashMap(setClass);
    }

    public MultiValuedHashMap() {
        this(16, 0.75f, ArrayList.class);
    }

    public MultiValuedHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f, ArrayList.class);
    }

    public MultiValuedHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, ArrayList.class);
    }

    public MultiValuedHashMap(int initialCapacity, float loadFactor, int initialCollectionCapacity) {
        this(initialCapacity, loadFactor, ArrayList.class, initialCollectionCapacity);
    }

    public MultiValuedHashMap(MultiValuedMap<? extends K, ? extends V> map) {
        this(16, 0.75f, ArrayList.class);
        super.putAll(map);
    }

    public MultiValuedHashMap(Map<? extends K, ? extends V> map) {
        this(16, 0.75f, ArrayList.class);
        super.putAll(map);
    }

    protected <C extends Collection<V>> MultiValuedHashMap(int initialCapacity, float loadFactor, Class<C> collectionClazz) {
        super(new HashMap(initialCapacity, loadFactor), collectionClazz);
    }

    protected <C extends Collection<V>> MultiValuedHashMap(int initialCapacity, float loadFactor, Class<C> collectionClazz, int initialCollectionCapacity) {
        super(new HashMap(initialCapacity, loadFactor), collectionClazz, initialCollectionCapacity);
    }

    private static class SetValuedHashMap<K, V>
    extends AbstractSetValuedMap<K, V> {
        private static final long serialVersionUID = 20150612L;

        public <C extends Set<V>> SetValuedHashMap(Class<C> setClazz) {
            super(new HashMap(16, 0.75f), setClazz);
        }

        public <C extends Set<V>> SetValuedHashMap(Class<C> setClazz, int initialSetCapacity) {
            super(new HashMap(16, 0.75f), setClazz, initialSetCapacity);
        }
    }

    private static class ListValuedHashMap<K, V>
    extends AbstractListValuedMap<K, V> {
        private static final long serialVersionUID = 20150612L;

        public <C extends List<V>> ListValuedHashMap(Class<C> listClazz) {
            super(new HashMap(16, 0.75f), listClazz);
        }

        public <C extends List<V>> ListValuedHashMap(Class<C> listClazz, int initialListCapacity) {
            super(new HashMap(16, 0.75f), listClazz, initialListCapacity);
        }
    }
}

