/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.multimap;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.collections4.SetValuedMap;
import org.apache.commons.collections4.multimap.AbstractMultiValuedMap;

public abstract class AbstractSetValuedMap<K, V>
extends AbstractMultiValuedMap<K, V>
implements SetValuedMap<K, V> {
    private static final long serialVersionUID = 20150612L;

    protected <C extends Set<V>> AbstractSetValuedMap(Map<K, ? super C> map, Class<C> setClazz) {
        super(map, setClazz);
    }

    protected <C extends Set<V>> AbstractSetValuedMap(Map<K, ? super C> map, Class<C> setClazz, int initialSetCapacity) {
        super(map, setClazz, initialSetCapacity);
    }

    @Override
    public Set<V> get(K key) {
        return new WrappedSet(key);
    }

    @Override
    public Set<V> remove(Object key) {
        return SetUtils.emptyIfNull((Set)this.getMap().remove(key));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SetValuedMap) {
            return this.asMap().equals(((SetValuedMap)obj).asMap());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.asMap().hashCode();
    }

    protected class WrappedSet
    extends AbstractMultiValuedMap.WrappedCollection
    implements Set<V> {
        public WrappedSet(K key) {
            super(key);
        }

        @Override
        public boolean equals(Object other) {
            Set set = (Set)this.getMapping();
            if (set == null) {
                return Collections.emptySet().equals(other);
            }
            if (!(other instanceof Set)) {
                return false;
            }
            Set otherSet = (Set)other;
            return SetUtils.isEqualSet(set, otherSet);
        }

        @Override
        public int hashCode() {
            Set set = (Set)this.getMapping();
            return SetUtils.hashCodeForSet(set);
        }
    }
}

