/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.TripleStore;
import com.hp.hpl.jena.mem.NodeToTriplesMapBase;
import com.hp.hpl.jena.mem.ObjectIterator;
import com.hp.hpl.jena.mem.StoreTripleIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.Iterator;

public abstract class GraphTripleStoreBase
implements TripleStore {
    protected final Graph parent;
    protected NodeToTriplesMapBase subjects;
    protected NodeToTriplesMapBase predicates;
    protected NodeToTriplesMapBase objects;
    private static final Map1<Object, Node> expectNode = new Map1<Object, Node>(){

        @Override
        public Node map1(Object o) {
            return (Node)o;
        }
    };

    protected GraphTripleStoreBase(Graph parent, NodeToTriplesMapBase subjects, NodeToTriplesMapBase predicates, NodeToTriplesMapBase objects) {
        this.parent = parent;
        this.subjects = subjects;
        this.objects = objects;
        this.predicates = predicates;
    }

    @Override
    public void close() {
        this.objects = null;
        this.predicates = null;
        this.subjects = null;
    }

    @Override
    public void add(Triple t) {
        if (this.subjects.add(t)) {
            this.predicates.add(t);
            this.objects.add(t);
        }
    }

    @Override
    public void delete(Triple t) {
        if (this.subjects.remove(t)) {
            this.predicates.remove(t);
            this.objects.remove(t);
        }
    }

    @Override
    public void clear() {
        this.subjects.clear();
        this.predicates.clear();
        this.objects.clear();
    }

    @Override
    public int size() {
        return this.subjects.size();
    }

    @Override
    public boolean isEmpty() {
        return this.subjects.isEmpty();
    }

    @Override
    public ExtendedIterator<Node> listSubjects() {
        return this.expectOnlyNodes(this.subjects.domain());
    }

    @Override
    public ExtendedIterator<Node> listPredicates() {
        return this.expectOnlyNodes(this.predicates.domain());
    }

    private ExtendedIterator<Node> expectOnlyNodes(Iterator<Object> elements) {
        return WrappedIterator.createNoRemove(elements).mapWith(expectNode);
    }

    @Override
    public ExtendedIterator<Node> listObjects() {
        return new ObjectIterator(this.objects.domain()){

            @Override
            protected Iterator<Triple> iteratorFor(Object y) {
                return GraphTripleStoreBase.this.objects.iteratorForIndexed(y);
            }
        };
    }

    @Override
    public boolean contains(Triple t) {
        return this.subjects.containsBySameValueAs(t);
    }

    public boolean containsByEquality(Triple t) {
        return this.subjects.contains(t);
    }

    @Override
    public ExtendedIterator<Triple> find(TripleMatch tm) {
        Triple t = tm.asTriple();
        Node pm = t.getPredicate();
        Node om = t.getObject();
        Node sm = t.getSubject();
        if (sm.isConcrete()) {
            return new StoreTripleIterator(this.parent, this.subjects.iterator(sm, pm, om), this.subjects, this.predicates, this.objects);
        }
        if (om.isConcrete()) {
            return new StoreTripleIterator(this.parent, this.objects.iterator(om, sm, pm), this.objects, this.subjects, this.predicates);
        }
        if (pm.isConcrete()) {
            return new StoreTripleIterator(this.parent, this.predicates.iterator(pm, om, sm), this.predicates, this.subjects, this.objects);
        }
        return new StoreTripleIterator(this.parent, this.subjects.iterateAll(), this.subjects, this.predicates, this.objects);
    }
}

