/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.extractor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.es.SpanishAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.hi.HindiAnalyzer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tr.TurkishAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.util.Version;
import org.openstreetmap.josm.plugins.extractor.FrequenceExtractor;
import org.openstreetmap.josm.plugins.extractor.LanguageDetector;

public class Analyzer {
    private final String osmFilePath;
    private static final HashSet<String> stopWordsList = new HashSet();
    private ArrayList<Map.Entry<String, Integer>> frequencies;
    private final LanguageDetector languageDetector;

    public Analyzer(String osmFilePath, LanguageDetector languageDetector) {
        this.osmFilePath = osmFilePath;
        this.languageDetector = languageDetector;
    }

    public void runAnalysis() {
        FrequenceExtractor frequenceExtractor = new FrequenceExtractor(this.osmFilePath);
        frequenceExtractor.parseDocument();
        Set<Map.Entry<String, Integer>> frequencyEntries = frequenceExtractor.getFrequency().entrySet();
        this.loadStopWords();
        ArrayList<Map.Entry<String, Integer>> normalizedList = new ArrayList<Map.Entry<String, Integer>>();
        ArrayList<String> sampleList = new ArrayList<String>();
        int iters = 0;
        for (Map.Entry<String, Integer> entry : frequencyEntries) {
            if (iters < 10) {
                sampleList.add(entry.getKey());
                ++iters;
            }
            if (stopWordsList.contains(entry.getKey())) continue;
            String normalizedName = entry.getKey().toLowerCase();
            normalizedName = normalizedName.replaceAll("[-+.^:,?;'{}\"!()\\[\\]]", "");
            AbstractMap.SimpleEntry<String, Integer> normalizedEntry = new AbstractMap.SimpleEntry<String, Integer>(normalizedName, entry.getValue());
            normalizedList.add(normalizedEntry);
        }
        HashMap<String, Integer> langs = new HashMap<String, Integer>();
        langs.put("en", 0);
        langs.put("el", 0);
        langs.put("de", 0);
        langs.put("es", 0);
        langs.put("ru", 0);
        langs.put("hi", 0);
        langs.put("zh", 0);
        langs.put("tr", 0);
        langs.put("fr", 0);
        for (String word : sampleList) {
            String lang;
            if (word.isEmpty()) continue;
            switch (lang = this.languageDetector.detect(word)) {
                case "en": {
                    langs.put("en", (Integer)langs.get("en") + 1);
                    break;
                }
                case "el": {
                    langs.put("el", (Integer)langs.get("el") + 1);
                    break;
                }
                case "de": {
                    langs.put("de", (Integer)langs.get("de") + 1);
                    break;
                }
                case "es": {
                    langs.put("es", (Integer)langs.get("es") + 1);
                    break;
                }
                case "ru": {
                    langs.put("ru", (Integer)langs.get("ru") + 1);
                    break;
                }
                case "fr": {
                    langs.put("fr", (Integer)langs.get("fr") + 1);
                    break;
                }
                case "zh": {
                    langs.put("zh", (Integer)langs.get("zh") + 1);
                    break;
                }
                case "tr": {
                    langs.put("tr", (Integer)langs.get("tr") + 1);
                    break;
                }
                case "hi": {
                    langs.put("hi", (Integer)langs.get("hi") + 1);
                    break;
                }
            }
        }
        int n = (Integer)langs.get("en");
        String dominantLanguage = "en";
        for (Map.Entry lang : langs.entrySet()) {
            int n2;
            if ((Integer)lang.getValue() <= n2) continue;
            n2 = (Integer)lang.getValue();
            dominantLanguage = (String)lang.getKey();
        }
        switch (dominantLanguage) {
            case "en": {
                normalizedList = Analyzer.stemEnglish(normalizedList);
                break;
            }
            case "el": {
                normalizedList = Analyzer.stemGreek(normalizedList);
                break;
            }
            case "de": {
                normalizedList = Analyzer.stemGerman(normalizedList);
                break;
            }
            case "es": {
                normalizedList = Analyzer.stemSpanish(normalizedList);
                break;
            }
            case "ru": {
                normalizedList = Analyzer.stemRussian(normalizedList);
                break;
            }
            case "fr": {
                normalizedList = Analyzer.stemFrench(normalizedList);
                break;
            }
            case "zh": {
                normalizedList = Analyzer.stemChinese(normalizedList);
                break;
            }
            case "tr": {
                normalizedList = Analyzer.stemTurkish(normalizedList);
                break;
            }
            case "hi": {
                normalizedList = Analyzer.stemHindi(normalizedList);
                break;
            }
            default: {
                normalizedList = Analyzer.stemEnglish(normalizedList);
            }
        }
        Collections.sort(normalizedList, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        this.setFrequencies(normalizedList);
    }

    private static ArrayList<Map.Entry<String, Integer>> stemGreek(List<Map.Entry<String, Integer>> normalizedList) {
        GreekAnalyzer greekAnalyzer = new GreekAnalyzer(Version.LUCENE_36);
        QueryParser greekParser = new QueryParser(Version.LUCENE_36, "", greekAnalyzer);
        ArrayList<Map.Entry<String, Integer>> stemmedList = new ArrayList<Map.Entry<String, Integer>>();
        for (Map.Entry<String, Integer> entry : normalizedList) {
            if (entry.getKey().isEmpty()) continue;
            try {
                String stemmedWord = greekParser.parse(entry.getKey()).toString();
                AbstractMap.SimpleEntry<String, Integer> stemmed = new AbstractMap.SimpleEntry<String, Integer>(stemmedWord, entry.getValue());
                if (stemmedWord.equals("")) continue;
                stemmedList.add(stemmed);
            }
            catch (ParseException ex) {
                Logger.getLogger(Analyzer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return stemmedList;
    }

    private static ArrayList<Map.Entry<String, Integer>> stemEnglish(List<Map.Entry<String, Integer>> normalizedList) {
        EnglishAnalyzer englishAnalyzer = new EnglishAnalyzer(Version.LUCENE_36);
        QueryParser englishParser = new QueryParser(Version.LUCENE_36, "", englishAnalyzer);
        ArrayList<Map.Entry<String, Integer>> stemmedList = new ArrayList<Map.Entry<String, Integer>>();
        for (Map.Entry<String, Integer> entry : normalizedList) {
            if (entry.getKey().isEmpty()) continue;
            try {
                String stemmedWord = englishParser.parse(entry.getKey()).toString();
                AbstractMap.SimpleEntry<String, Integer> stemmed = new AbstractMap.SimpleEntry<String, Integer>(stemmedWord, entry.getValue());
                if (stemmedWord.equals("")) continue;
                stemmedList.add(stemmed);
            }
            catch (ParseException ex) {
                Logger.getLogger(Analyzer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return stemmedList;
    }

    private static ArrayList<Map.Entry<String, Integer>> stemGerman(List<Map.Entry<String, Integer>> normalizedList) {
        GermanAnalyzer germanAnalyzer = new GermanAnalyzer(Version.LUCENE_36);
        QueryParser germanParser = new QueryParser(Version.LUCENE_36, "", germanAnalyzer);
        ArrayList<Map.Entry<String, Integer>> stemmedList = new ArrayList<Map.Entry<String, Integer>>();
        for (Map.Entry<String, Integer> entry : normalizedList) {
            if (entry.getKey().isEmpty()) continue;
            try {
                String stemmedWord = germanParser.parse(entry.getKey()).toString();
                AbstractMap.SimpleEntry<String, Integer> stemmed = new AbstractMap.SimpleEntry<String, Integer>(stemmedWord, entry.getValue());
                if (stemmedWord.equals("")) continue;
                stemmedList.add(stemmed);
            }
            catch (ParseException ex) {
                Logger.getLogger(Analyzer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return stemmedList;
    }

    private static ArrayList<Map.Entry<String, Integer>> stemSpanish(List<Map.Entry<String, Integer>> normalizedList) {
        SpanishAnalyzer spanishAnalyzer = new SpanishAnalyzer(Version.LUCENE_36);
        QueryParser spanishParser = new QueryParser(Version.LUCENE_36, "", spanishAnalyzer);
        ArrayList<Map.Entry<String, Integer>> stemmedList = new ArrayList<Map.Entry<String, Integer>>();
        for (Map.Entry<String, Integer> entry : normalizedList) {
            if (entry.getKey().isEmpty()) continue;
            try {
                String stemmedWord = spanishParser.parse(entry.getKey()).toString();
                AbstractMap.SimpleEntry<String, Integer> stemmed = new AbstractMap.SimpleEntry<String, Integer>(stemmedWord, entry.getValue());
                if (stemmedWord.equals("")) continue;
                stemmedList.add(stemmed);
            }
            catch (ParseException ex) {
                Logger.getLogger(Analyzer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return stemmedList;
    }

    private static ArrayList<Map.Entry<String, Integer>> stemRussian(List<Map.Entry<String, Integer>> normalizedList) {
        RussianAnalyzer russianAnalyzer = new RussianAnalyzer(Version.LUCENE_36);
        QueryParser russianParser = new QueryParser(Version.LUCENE_36, "", russianAnalyzer);
        ArrayList<Map.Entry<String, Integer>> stemmedList = new ArrayList<Map.Entry<String, Integer>>();
        for (Map.Entry<String, Integer> entry : normalizedList) {
            if (entry.getKey().isEmpty()) continue;
            try {
                String stemmedWord = russianParser.parse(entry.getKey()).toString();
                AbstractMap.SimpleEntry<String, Integer> stemmed = new AbstractMap.SimpleEntry<String, Integer>(stemmedWord, entry.getValue());
                if (stemmedWord.equals("")) continue;
                stemmedList.add(stemmed);
            }
            catch (ParseException ex) {
                Logger.getLogger(Analyzer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return stemmedList;
    }

    private static ArrayList<Map.Entry<String, Integer>> stemFrench(List<Map.Entry<String, Integer>> normalizedList) {
        FrenchAnalyzer frenchAnalyzer = new FrenchAnalyzer(Version.LUCENE_36);
        QueryParser frenchParser = new QueryParser(Version.LUCENE_36, "", frenchAnalyzer);
        ArrayList<Map.Entry<String, Integer>> stemmedList = new ArrayList<Map.Entry<String, Integer>>();
        for (Map.Entry<String, Integer> entry : normalizedList) {
            if (entry.getKey().isEmpty()) continue;
            try {
                String stemmedWord = frenchParser.parse(entry.getKey()).toString();
                AbstractMap.SimpleEntry<String, Integer> stemmed = new AbstractMap.SimpleEntry<String, Integer>(stemmedWord, entry.getValue());
                if (stemmedWord.equals("")) continue;
                stemmedList.add(stemmed);
            }
            catch (ParseException ex) {
                Logger.getLogger(Analyzer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return stemmedList;
    }

    private static ArrayList<Map.Entry<String, Integer>> stemChinese(List<Map.Entry<String, Integer>> normalizedList) {
        StandardAnalyzer chineseAnalyzer = new StandardAnalyzer(Version.LUCENE_36);
        QueryParser chineseParser = new QueryParser(Version.LUCENE_36, "", chineseAnalyzer);
        ArrayList<Map.Entry<String, Integer>> stemmedList = new ArrayList<Map.Entry<String, Integer>>();
        for (Map.Entry<String, Integer> entry : normalizedList) {
            if (entry.getKey().isEmpty()) continue;
            try {
                String stemmedWord = chineseParser.parse(entry.getKey()).toString();
                AbstractMap.SimpleEntry<String, Integer> stemmed = new AbstractMap.SimpleEntry<String, Integer>(stemmedWord, entry.getValue());
                if (stemmedWord.equals("")) continue;
                stemmedList.add(stemmed);
            }
            catch (ParseException ex) {
                Logger.getLogger(Analyzer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return stemmedList;
    }

    private static ArrayList<Map.Entry<String, Integer>> stemTurkish(List<Map.Entry<String, Integer>> normalizedList) {
        TurkishAnalyzer turkishAnalyzer = new TurkishAnalyzer(Version.LUCENE_36);
        QueryParser turkishParser = new QueryParser(Version.LUCENE_36, "", turkishAnalyzer);
        ArrayList<Map.Entry<String, Integer>> stemmedList = new ArrayList<Map.Entry<String, Integer>>();
        for (Map.Entry<String, Integer> entry : normalizedList) {
            if (entry.getKey().isEmpty()) continue;
            try {
                String stemmedWord = turkishParser.parse(entry.getKey()).toString();
                AbstractMap.SimpleEntry<String, Integer> stemmed = new AbstractMap.SimpleEntry<String, Integer>(stemmedWord, entry.getValue());
                if (stemmedWord.equals("")) continue;
                stemmedList.add(stemmed);
            }
            catch (ParseException ex) {
                Logger.getLogger(Analyzer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return stemmedList;
    }

    private static ArrayList<Map.Entry<String, Integer>> stemHindi(List<Map.Entry<String, Integer>> normalizedList) {
        HindiAnalyzer hindiAnalyzer = new HindiAnalyzer(Version.LUCENE_36);
        QueryParser hindiParser = new QueryParser(Version.LUCENE_36, "", hindiAnalyzer);
        ArrayList<Map.Entry<String, Integer>> stemmedList = new ArrayList<Map.Entry<String, Integer>>();
        for (Map.Entry<String, Integer> entry : normalizedList) {
            if (entry.getKey().isEmpty()) continue;
            try {
                String stemmedWord = hindiParser.parse(entry.getKey()).toString();
                AbstractMap.SimpleEntry<String, Integer> stemmed = new AbstractMap.SimpleEntry<String, Integer>(stemmedWord, entry.getValue());
                if (stemmedWord.equals("")) continue;
                stemmedList.add(stemmed);
            }
            catch (ParseException ex) {
                Logger.getLogger(Analyzer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return stemmedList;
    }

    private void loadStopWords() {
        InputStream fstream = Analyzer.class.getResourceAsStream("/resources/files/stopWords.txt");
        try (BufferedReader br = new BufferedReader(new InputStreamReader(fstream));){
            String strLine;
            while ((strLine = br.readLine()) != null) {
                stopWordsList.add(strLine);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Analyzer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void setFrequencies(ArrayList<Map.Entry<String, Integer>> frequencies) {
        this.frequencies = frequencies;
    }

    public List<Map.Entry<String, Integer>> getFrequencies() {
        return Collections.unmodifiableList(this.frequencies);
    }

    public List<Map.Entry<String, Integer>> getTopKMostFrequent(int topK) {
        if (topK > this.frequencies.size()) {
            return Collections.unmodifiableList(this.frequencies);
        }
        return this.frequencies.subList(0, topK);
    }

    public List<Map.Entry<String, Integer>> getWithFrequency(int minFrequency) {
        ArrayList<Map.Entry<String, Integer>> withFrequency = new ArrayList<Map.Entry<String, Integer>>();
        for (Map.Entry<String, Integer> entry : this.frequencies) {
            if (entry.getValue() > minFrequency) {
                withFrequency.add(entry);
                continue;
            }
            return withFrequency;
        }
        return withFrequency;
    }
}

