/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.util;

import java.io.Closeable;
import java.io.IOException;

public final class IoUtils {
    public static void closeQuietly(boolean mayThrow, Closeable ... closeables) throws IOException {
        IOException firstException = null;
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException ioException) {
                if (!mayThrow || firstException != null) continue;
                firstException = ioException;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    private IoUtils() {
    }
}

