/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.io.download.MapillaryDownloader;
import org.openstreetmap.josm.plugins.mapillary.oauth.MapillaryUser;
import org.openstreetmap.josm.plugins.mapillary.oauth.OAuthPortListener;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryUtils;
import org.openstreetmap.josm.tools.I18n;

public class MapillaryPreferenceSetting
implements SubPreferenceSetting {
    private JCheckBox reverseButtons = new JCheckBox(I18n.tr((String)"Reverse buttons position when displaying images.", (Object[])new Object[0]));
    private JComboBox<String> downloadMode = new JComboBox<String>(MapillaryDownloader.MODES);
    private JCheckBox displayHour = new JCheckBox(I18n.tr((String)"Display hour when the picture was taken", (Object[])new Object[0]));
    private JCheckBox format24 = new JCheckBox(I18n.tr((String)"Use 24 hour format", (Object[])new Object[0]));
    private JCheckBox moveTo = new JCheckBox(I18n.tr((String)"Move to picture''s location with next/previous buttons", (Object[])new Object[0]));
    private JButton login;

    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane gui) {
        return gui.getDisplayPreference();
    }

    public void addGui(PreferenceTabbedPane gui) {
        JPanel panel = new JPanel();
        this.reverseButtons.setSelected(Main.pref.getBoolean("mapillary.reverse-buttons"));
        this.displayHour.setSelected(Main.pref.getBoolean("mapillary.display-hour", true));
        this.format24.setSelected(Main.pref.getBoolean("mapillary.format-24"));
        this.moveTo.setSelected(Main.pref.getBoolean("mapillary.move-to-picture", true));
        panel.setLayout(new FlowLayout(0));
        panel.add(this.reverseButtons);
        if (Main.pref.get("mapillary.download-mode").equals(MapillaryDownloader.MODES[0])) {
            this.downloadMode.setSelectedItem(MapillaryDownloader.MODES[0]);
        }
        if (Main.pref.get("mapillary.download-mode").equals(MapillaryDownloader.MODES[1])) {
            this.downloadMode.setSelectedItem(MapillaryDownloader.MODES[1]);
        }
        if (Main.pref.get("mapillary.download-mode").equals(MapillaryDownloader.MODES[2])) {
            this.downloadMode.setSelectedItem(MapillaryDownloader.MODES[2]);
        }
        JPanel downloadModePanel = new JPanel();
        downloadModePanel.add(new JLabel(I18n.tr((String)"Download mode: ", (Object[])new Object[0])));
        downloadModePanel.add(this.downloadMode);
        panel.add(downloadModePanel);
        panel.add(this.displayHour);
        panel.add(this.format24);
        panel.add(this.moveTo);
        this.login = new JButton(new LoginAction());
        if (MapillaryUser.getUsername() == null) {
            this.login.setText("Login");
        } else {
            this.login.setText("Logged as: " + MapillaryUser.getUsername() + ". Click to relogin.");
        }
        panel.add(this.login);
        if (MapillaryUser.getUsername() != null) {
            JButton logout = new JButton(new LogoutAction());
            logout.setText("Logout");
            panel.add(logout);
        }
        gui.getDisplayPreference().addSubTab((SubPreferenceSetting)this, "Mapillary", (Component)panel);
    }

    public boolean ok() {
        boolean mod = false;
        Main.pref.put("mapillary.reverse-buttons", this.reverseButtons.isSelected());
        MapillaryPlugin.setMenuEnabled(MapillaryPlugin.DOWNLOAD_VIEW_MENU, false);
        if (this.downloadMode.getSelectedItem().equals(MapillaryDownloader.MODES[0])) {
            Main.pref.put("mapillary.download-mode", MapillaryDownloader.MODES[0]);
        }
        if (this.downloadMode.getSelectedItem().equals(MapillaryDownloader.MODES[1])) {
            Main.pref.put("mapillary.download-mode", MapillaryDownloader.MODES[1]);
        }
        if (this.downloadMode.getSelectedItem().equals(MapillaryDownloader.MODES[2])) {
            Main.pref.put("mapillary.download-mode", MapillaryDownloader.MODES[2]);
            MapillaryPlugin.setMenuEnabled(MapillaryPlugin.DOWNLOAD_VIEW_MENU, true);
        }
        Main.pref.put("mapillary.display-hour", this.displayHour.isSelected());
        Main.pref.put("mapillary.format-24", this.format24.isSelected());
        Main.pref.put("mapillary.move-to-picture", this.moveTo.isSelected());
        return mod;
    }

    public boolean isExpert() {
        return false;
    }

    public class LogoutAction
    extends AbstractAction {
        private static final long serialVersionUID = 3434780936404707219L;

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MapillaryUser.reset();
            Main.pref.put("mapillary.access-token", null);
            MapillaryPreferenceSetting.this.login.setText("Login");
        }
    }

    public class LoginAction
    extends AbstractAction {
        private static final long serialVersionUID = -3908477563072057344L;

        @Override
        public void actionPerformed(ActionEvent arg0) {
            OAuthPortListener portListener = new OAuthPortListener();
            portListener.start();
            String url = "http://www.mapillary.com/connect?redirect_uri=http:%2F%2Flocalhost:8763%2F&client_id=T1Fzd20xZjdtR0s1VDk5OFNIOXpYdzoxNDYyOGRkYzUyYTFiMzgz&response_type=token&scope=user:read%20public:upload%20public:write";
            try {
                MapillaryUtils.browse(new URL(url));
            }
            catch (MalformedURLException e) {
                Main.error((Throwable)e);
            }
        }
    }
}

