/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.cache;

import java.io.IOException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.cache.ICachedLoaderListener;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.cache.MapillaryCache;

public class CacheUtils {
    private static IgnoreDownload IGNORE_DOWNLOAD = new IgnoreDownload();

    public static void downloadPicture(MapillaryImage img) {
        CacheUtils.downloadPicture(img, PICTURE.BOTH);
    }

    public static void downloadPicture(MapillaryImage img, PICTURE pic) {
        switch (pic) {
            case BOTH: {
                if (new MapillaryCache(img.getKey(), MapillaryCache.Type.THUMBNAIL).get() == null) {
                    CacheUtils.submit(img.getKey(), MapillaryCache.Type.THUMBNAIL, IGNORE_DOWNLOAD);
                }
                if (new MapillaryCache(img.getKey(), MapillaryCache.Type.FULL_IMAGE).get() != null) break;
                CacheUtils.submit(img.getKey(), MapillaryCache.Type.FULL_IMAGE, IGNORE_DOWNLOAD);
                break;
            }
            case THUMBNAIL: {
                CacheUtils.submit(img.getKey(), MapillaryCache.Type.THUMBNAIL, IGNORE_DOWNLOAD);
                break;
            }
            case FULL_IMAGE: {
                CacheUtils.submit(img.getKey(), MapillaryCache.Type.FULL_IMAGE, IGNORE_DOWNLOAD);
            }
        }
    }

    public static void submit(String key, MapillaryCache.Type type, ICachedLoaderListener lis) {
        try {
            new MapillaryCache(key, type).submit(lis, false);
        }
        catch (IOException e) {
            Main.error((Throwable)e);
        }
    }

    private static class IgnoreDownload
    implements ICachedLoaderListener {
        private IgnoreDownload() {
        }

        public void loadingFinished(CacheEntry arg0, CacheEntryAttributes arg1, ICachedLoaderListener.LoadResult arg2) {
        }
    }

    public static enum PICTURE {
        THUMBNAIL,
        FULL_IMAGE,
        BOTH;

    }
}

