/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.imaging.ImageReadException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.MapillarySequence;
import org.openstreetmap.josm.plugins.mapillary.history.MapillaryRecord;
import org.openstreetmap.josm.plugins.mapillary.history.commands.CommandImport;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MapillaryImportIntoSequenceAction
extends JosmAction {
    private static final long serialVersionUID = -9190217809965894878L;
    private JFileChooser chooser;
    private List<MapillaryAbstractImage> images;

    public MapillaryImportIntoSequenceAction() {
        super(I18n.tr((String)"Import pictures into sequence", (Object[])new Object[0]), MapillaryPlugin.getProvider("icon24.png"), I18n.tr((String)"Import local pictures", (Object[])new Object[0]), Shortcut.registerShortcut((String)"Import Mapillary Sequence", (String)I18n.tr((String)"Import pictures into Mapillary layer in a sequence", (Object[])new Object[0]), (int)65535, (int)5000), false, "mapillaryImportSequence", false);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent arg0) {
        this.images = new LinkedList<MapillaryAbstractImage>();
        this.chooser = new JFileChooser();
        File startDirectory = new File(Main.pref.get("mapillary.start-directory", System.getProperty("user.home")));
        this.chooser.setCurrentDirectory(startDirectory);
        this.chooser.setDialogTitle(I18n.tr((String)"Select pictures", (Object[])new Object[0]));
        this.chooser.setFileSelectionMode(2);
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.addChoosableFileFilter(new FileNameExtensionFilter("images", "jpg", "jpeg"));
        this.chooser.setMultiSelectionEnabled(true);
        if (this.chooser.showOpenDialog(Main.parent) == 0) {
            File file;
            for (int i = 0; i < this.chooser.getSelectedFiles().length && (file = this.chooser.getSelectedFiles()[i]) != null; ++i) {
                Main.pref.put("mapillary.start-directory", file.getParent());
                MapillaryLayer.getInstance();
                if (file.isDirectory()) {
                    for (int j = 0; j < file.listFiles().length; ++j) {
                        String extension = MapillaryUtils.getExtension(file.listFiles()[j]);
                        try {
                            if (!extension.equals("jpg") && !extension.equals("jpeg")) continue;
                            MapillaryUtils.readJPG(file.listFiles()[j], true);
                            continue;
                        }
                        catch (IOException | NullPointerException | ImageReadException e) {
                            Main.error((Throwable)e);
                        }
                    }
                    continue;
                }
                String extension = MapillaryUtils.getExtension(file);
                if (!extension.equals("jpg") && !extension.equals("jpeg")) continue;
                try {
                    this.images.add(MapillaryUtils.readJPG(file, true));
                    continue;
                }
                catch (ImageReadException ex) {
                    Main.error((Throwable)ex);
                    continue;
                }
                catch (IOException ex) {
                    Main.error((Throwable)ex);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            this.joinImages();
            MapillaryRecord.getInstance().addCommand(new CommandImport(this.images));
        }
        MapillaryUtils.showAllPictures();
    }

    public void joinImages() {
        Collections.sort(this.images, new MapillaryEpochComparator());
        MapillarySequence seq = new MapillarySequence();
        for (MapillaryAbstractImage img : this.images) {
            seq.add(img);
            img.setSequence(seq);
        }
    }

    public class MapillaryEpochComparator
    implements Comparator<MapillaryAbstractImage> {
        @Override
        public int compare(MapillaryAbstractImage arg0, MapillaryAbstractImage arg1) {
            if (arg0.getCapturedAt() < arg1.getCapturedAt()) {
                return -1;
            }
            if (arg0.getCapturedAt() > arg1.getCapturedAt()) {
                return 1;
            }
            return 0;
        }
    }
}

