/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.list;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_manager_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_list_player_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_playback_mode_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_state_t;
import uk.co.caprica.vlcj.logger.Logger;
import uk.co.caprica.vlcj.medialist.MediaList;
import uk.co.caprica.vlcj.player.AbstractMediaPlayer;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.NativeString;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.list.MediaListPlayer;
import uk.co.caprica.vlcj.player.list.MediaListPlayerEventAdapter;
import uk.co.caprica.vlcj.player.list.MediaListPlayerEventListener;
import uk.co.caprica.vlcj.player.list.MediaListPlayerMode;
import uk.co.caprica.vlcj.player.list.events.MediaListPlayerEvent;
import uk.co.caprica.vlcj.player.list.events.MediaListPlayerEventFactory;
import uk.co.caprica.vlcj.player.list.events.MediaListPlayerEventType;

public class DefaultMediaListPlayer
extends AbstractMediaPlayer
implements MediaListPlayer {
    private final List<MediaListPlayerEventListener> eventListenerList = new ArrayList<MediaListPlayerEventListener>();
    private final MediaListPlayerEventFactory eventFactory = new MediaListPlayerEventFactory(this);
    private final ExecutorService listenersService = Executors.newSingleThreadExecutor();
    private libvlc_media_list_player_t mediaListPlayerInstance;
    private libvlc_event_manager_t mediaListPlayerEventManager;
    private libvlc_callback_t callback;
    private MediaPlayer mediaPlayer;
    private int eventMask = MediaListPlayerEventType.ALL.value();
    private MediaList mediaList;
    private Object userData;
    private final AtomicReference<String> currentMrl = new AtomicReference();
    private final AtomicBoolean released = new AtomicBoolean();

    public DefaultMediaListPlayer(LibVlc libvlc, libvlc_instance_t instance) {
        super(libvlc, instance);
        Logger.debug("DefaultMediaListPlayer(libvlc={}, instance={})", new Object[]{libvlc, instance});
        this.createInstance();
    }

    @Override
    public void addMediaListPlayerEventListener(MediaListPlayerEventListener listener) {
        Logger.debug("addMediaPlayerEventListener(listener={})", listener);
        this.eventListenerList.add(listener);
    }

    @Override
    public void removeMediaListPlayerEventListener(MediaListPlayerEventListener listener) {
        Logger.debug("removeMediaPlayerEventListener(listener={})", listener);
        this.eventListenerList.remove(listener);
    }

    @Override
    public void enableEvents(int eventMask) {
        Logger.debug("enableEvents(eventMask={})", eventMask);
        this.eventMask = eventMask;
    }

    @Override
    public void setMediaPlayer(MediaPlayer mediaPlayer) {
        Logger.debug("setMediaPlayer(mediaPlayer={})", mediaPlayer);
        this.mediaPlayer = mediaPlayer;
        this.libvlc.libvlc_media_list_player_set_media_player(this.mediaListPlayerInstance, mediaPlayer.mediaPlayerInstance());
    }

    @Override
    public void setMediaList(MediaList mediaList) {
        Logger.debug("setMediaList(mediaList={})", mediaList);
        this.libvlc.libvlc_media_list_player_set_media_list(this.mediaListPlayerInstance, mediaList.mediaListInstance());
        this.mediaList = mediaList;
    }

    @Override
    public MediaList getMediaList() {
        Logger.debug("getMediaList()", new Object[0]);
        return this.mediaList;
    }

    @Override
    public void play() {
        Logger.debug("play()", new Object[0]);
        if (this.mediaPlayer instanceof EmbeddedMediaPlayer) {
            ((EmbeddedMediaPlayer)this.mediaPlayer).attachVideoSurface();
        }
        this.libvlc.libvlc_media_list_player_play(this.mediaListPlayerInstance);
    }

    @Override
    public void pause() {
        Logger.debug("pause()", new Object[0]);
        this.libvlc.libvlc_media_list_player_pause(this.mediaListPlayerInstance);
    }

    @Override
    public void stop() {
        Logger.debug("stop()", new Object[0]);
        this.libvlc.libvlc_media_list_player_stop(this.mediaListPlayerInstance);
    }

    @Override
    public boolean playItem(int itemIndex) {
        Logger.debug("playItem(itemIndex={})", itemIndex);
        if (this.mediaList != null && itemIndex >= 0 && itemIndex < this.mediaList.size()) {
            return this.libvlc.libvlc_media_list_player_play_item_at_index(this.mediaListPlayerInstance, itemIndex) == 0;
        }
        throw new IllegalArgumentException("Item index is out of bounds");
    }

    @Override
    public void playNext() {
        Logger.debug("playNext()", new Object[0]);
        this.libvlc.libvlc_media_list_player_next(this.mediaListPlayerInstance);
    }

    @Override
    public void playPrevious() {
        Logger.debug("playPrevious()", new Object[0]);
        this.libvlc.libvlc_media_list_player_previous(this.mediaListPlayerInstance);
    }

    @Override
    public boolean isPlaying() {
        Logger.debug("isPlaying()", new Object[0]);
        return this.libvlc.libvlc_media_list_player_is_playing(this.mediaListPlayerInstance) != 0;
    }

    @Override
    public libvlc_state_t getMediaListPlayerState() {
        Logger.debug("getMediaListPlayerState()", new Object[0]);
        return libvlc_state_t.state(this.libvlc.libvlc_media_list_player_get_state(this.mediaListPlayerInstance));
    }

    @Override
    public void setMode(MediaListPlayerMode mode) {
        libvlc_playback_mode_e playbackMode;
        Logger.debug("setMode(mode={})", new Object[]{mode});
        switch (mode) {
            case DEFAULT: {
                playbackMode = libvlc_playback_mode_e.libvlc_playback_mode_default;
                break;
            }
            case LOOP: {
                playbackMode = libvlc_playback_mode_e.libvlc_playback_mode_loop;
                break;
            }
            case REPEAT: {
                playbackMode = libvlc_playback_mode_e.libvlc_playback_mode_repeat;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid mode " + (Object)((Object)mode));
            }
        }
        this.libvlc.libvlc_media_list_player_set_playback_mode(this.mediaListPlayerInstance, playbackMode.intValue());
    }

    @Override
    public String mrl(libvlc_media_t mediaInstance) {
        Logger.debug("mrl(mediaInstance={})", new Object[]{mediaInstance});
        return NativeString.getNativeString(this.libvlc, this.libvlc.libvlc_media_get_mrl(mediaInstance));
    }

    @Override
    public Object userData() {
        Logger.debug("userData()", new Object[0]);
        return this.userData;
    }

    @Override
    public void userData(Object userData) {
        Logger.debug("userData(userData={})", userData);
        this.userData = userData;
    }

    @Override
    public final String currentMrl() {
        Logger.debug("currentMrl()", new Object[0]);
        return this.currentMrl.get();
    }

    @Override
    public final void release() {
        Logger.debug("release()", new Object[0]);
        if (this.released.compareAndSet(false, true)) {
            this.destroyInstance();
        }
    }

    private void createInstance() {
        Logger.debug("createInstance()", new Object[0]);
        this.mediaListPlayerInstance = this.libvlc.libvlc_media_list_player_new(this.instance);
        this.mediaListPlayerEventManager = this.libvlc.libvlc_media_list_player_event_manager(this.mediaListPlayerInstance);
        Logger.debug("mediaListPlayerEventManager={}", new Object[]{this.mediaListPlayerEventManager});
        this.registerEventListener();
        this.addMediaListPlayerEventListener(new NextItemHandler());
    }

    private void destroyInstance() {
        Logger.debug("destroyInstance()", new Object[0]);
        Logger.debug("Detach events...", new Object[0]);
        this.deregisterEventListener();
        Logger.debug("Events detached.", new Object[0]);
        this.eventListenerList.clear();
        if (this.mediaListPlayerInstance != null) {
            Logger.debug("Release media list player...", new Object[0]);
            this.libvlc.libvlc_media_list_player_release(this.mediaListPlayerInstance);
            Logger.debug("Media list player released", new Object[0]);
        }
        Logger.debug("Shut down listeners...", new Object[0]);
        this.listenersService.shutdown();
        Logger.debug("Listeners shut down.", new Object[0]);
    }

    private void registerEventListener() {
        Logger.debug("registerEventListener()", new Object[0]);
        this.callback = new VlcVideoPlayerCallback();
        for (libvlc_event_e event : libvlc_event_e.values()) {
            if (event.intValue() < libvlc_event_e.libvlc_MediaListPlayerNextItemSet.intValue() || event.intValue() > libvlc_event_e.libvlc_MediaListPlayerStopped.intValue()) continue;
            Logger.debug("event={}", new Object[]{event});
            int result = this.libvlc.libvlc_event_attach(this.mediaListPlayerEventManager, event.intValue(), this.callback, null);
            Logger.debug("result={}", result);
        }
    }

    private void deregisterEventListener() {
        Logger.debug("deregisterEventListener()", new Object[0]);
        if (this.callback != null) {
            for (libvlc_event_e event : libvlc_event_e.values()) {
                if (event.intValue() < libvlc_event_e.libvlc_MediaListPlayerNextItemSet.intValue() || event.intValue() > libvlc_event_e.libvlc_MediaListPlayerStopped.intValue()) continue;
                Logger.debug("event={}", new Object[]{event});
                this.libvlc.libvlc_event_detach(this.mediaListPlayerEventManager, event.intValue(), this.callback, null);
            }
            this.callback = null;
        }
    }

    @Override
    protected void finalize() throws Throwable {
        Logger.debug("finalize()", new Object[0]);
        Logger.debug("Media list player has been garbage collected", new Object[0]);
        super.finalize();
    }

    private class NextItemHandler
    extends MediaListPlayerEventAdapter {
        private libvlc_media_t mediaInstance;

        private NextItemHandler() {
        }

        @Override
        public void nextItem(MediaListPlayer mediaListPlayer, libvlc_media_t item, String itemMrl) {
            Logger.debug("nextItem(item={},itemMrl={})", new Object[]{item, itemMrl});
            this.deregisterMediaEventListener();
            this.mediaInstance = item;
            DefaultMediaListPlayer.this.currentMrl.set(itemMrl);
            this.registerMediaEventListener();
        }

        private void registerMediaEventListener() {
            Logger.debug("registerMediaEventListener()", new Object[0]);
            if (this.mediaInstance != null) {
                libvlc_event_manager_t mediaEventManager = DefaultMediaListPlayer.this.libvlc.libvlc_media_event_manager(this.mediaInstance);
                for (libvlc_event_e event : libvlc_event_e.values()) {
                    if (event.intValue() < libvlc_event_e.libvlc_MediaMetaChanged.intValue() || event.intValue() > libvlc_event_e.libvlc_MediaStateChanged.intValue()) continue;
                    Logger.debug("event={}", new Object[]{event});
                    int result = DefaultMediaListPlayer.this.libvlc.libvlc_event_attach(mediaEventManager, event.intValue(), DefaultMediaListPlayer.this.callback, null);
                    Logger.debug("result={}", result);
                }
            }
        }

        private void deregisterMediaEventListener() {
            Logger.debug("deregisterMediaEventListener()", new Object[0]);
            if (this.mediaInstance != null) {
                libvlc_event_manager_t mediaEventManager = DefaultMediaListPlayer.this.libvlc.libvlc_media_event_manager(this.mediaInstance);
                for (libvlc_event_e event : libvlc_event_e.values()) {
                    if (event.intValue() < libvlc_event_e.libvlc_MediaMetaChanged.intValue() || event.intValue() > libvlc_event_e.libvlc_MediaStateChanged.intValue()) continue;
                    Logger.debug("event={}", new Object[]{event});
                    DefaultMediaListPlayer.this.libvlc.libvlc_event_detach(mediaEventManager, event.intValue(), DefaultMediaListPlayer.this.callback, null);
                }
                Object var1_1 = null;
            }
        }
    }

    private final class NotifyListenersRunnable
    implements Runnable {
        private final MediaListPlayerEvent mediaListPlayerEvent;

        private NotifyListenersRunnable(MediaListPlayerEvent mediaListPlayerEvent) {
            this.mediaListPlayerEvent = mediaListPlayerEvent;
        }

        @Override
        public void run() {
            Logger.trace("run()", new Object[0]);
            for (int i = DefaultMediaListPlayer.this.eventListenerList.size() - 1; i >= 0; --i) {
                MediaListPlayerEventListener listener = (MediaListPlayerEventListener)DefaultMediaListPlayer.this.eventListenerList.get(i);
                try {
                    this.mediaListPlayerEvent.notify(listener);
                    continue;
                }
                catch (Exception e) {
                    Logger.warn("Event listener {} threw an exception", e, listener);
                }
            }
            Logger.trace("runnable exits", new Object[0]);
        }
    }

    private final class VlcVideoPlayerCallback
    implements libvlc_callback_t {
        private VlcVideoPlayerCallback() {
        }

        @Override
        public void callback(libvlc_event_t event, Pointer userData) {
            Logger.trace("callback(event={},userData={})", new Object[]{event, userData});
            if (!DefaultMediaListPlayer.this.eventListenerList.isEmpty()) {
                MediaListPlayerEvent mediaListPlayerEvent = DefaultMediaListPlayer.this.eventFactory.newMediaListPlayerEvent(event, DefaultMediaListPlayer.this.eventMask);
                Logger.trace("mediaListPlayerEvent={}", mediaListPlayerEvent);
                if (mediaListPlayerEvent != null) {
                    DefaultMediaListPlayer.this.listenersService.submit(new NotifyListenersRunnable(mediaListPlayerEvent));
                }
            }
        }
    }
}

