/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.plugin.routing;

import com.innovant.josm.plugin.routing.RoutingLayer;
import com.innovant.josm.plugin.routing.actions.AddRouteNodeAction;
import com.innovant.josm.plugin.routing.actions.MoveRouteNodeAction;
import com.innovant.josm.plugin.routing.actions.RemoveRouteNodeAction;
import com.innovant.josm.plugin.routing.gui.RoutingDialog;
import com.innovant.josm.plugin.routing.gui.RoutingMenu;
import com.innovant.josm.plugin.routing.gui.RoutingPreferenceDialog;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Action;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;

public class RoutingPlugin
extends Plugin
implements MapView.LayerChangeListener,
DataSetListenerAdapter.Listener {
    static Logger logger = Logger.getLogger(RoutingPlugin.class);
    private final ArrayList<RoutingLayer> layers;
    private RoutingDialog routingDialog;
    private final PreferenceSetting preferenceSettings;
    private AddRouteNodeAction addRouteNodeAction;
    private RemoveRouteNodeAction removeRouteNodeAction;
    private MoveRouteNodeAction moveRouteNodeAction;
    private IconToggleButton addRouteNodeButton;
    private IconToggleButton removeRouteNodeButton;
    private IconToggleButton moveRouteNodeButton;
    private final RoutingMenu menu;
    private static RoutingPlugin plugin;
    private final DataSetListenerAdapter datasetAdapter = new DataSetListenerAdapter((DataSetListenerAdapter.Listener)this);

    public RoutingPlugin(PluginInformation info) {
        super(info);
        plugin = this;
        File log4jConfigFile = new File("log4j.xml");
        if (log4jConfigFile.exists()) {
            DOMConfigurator.configure((String)log4jConfigFile.getPath());
        } else {
            System.err.println("Routing plugin warning: log4j configuration not found");
        }
        logger.debug((Object)"Loading routing plugin...");
        this.preferenceSettings = new RoutingPreferenceDialog();
        this.layers = new ArrayList();
        this.menu = new RoutingMenu();
        MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
        DatasetEventManager.getInstance().addDatasetListener((DataSetListener)this.datasetAdapter, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        logger.debug((Object)"Finished loading plugin");
    }

    public static RoutingPlugin getInstance() {
        return plugin;
    }

    public RoutingDialog getRoutingDialog() {
        return this.routingDialog;
    }

    public void addLayer() {
        OsmDataLayer osmLayer = Main.main.getEditLayer();
        if (osmLayer != null) {
            RoutingLayer layer = new RoutingLayer(I18n.tr((String)"Routing", (Object[])new Object[0]) + " [" + osmLayer.getName() + "]", osmLayer);
            this.layers.add(layer);
            Main.main.addLayer((Layer)layer);
        }
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            this.addRouteNodeAction = new AddRouteNodeAction(newFrame);
            this.removeRouteNodeAction = new RemoveRouteNodeAction(newFrame);
            this.moveRouteNodeAction = new MoveRouteNodeAction(newFrame);
            this.addRouteNodeButton = new IconToggleButton((Action)((Object)this.addRouteNodeAction));
            this.removeRouteNodeButton = new IconToggleButton((Action)((Object)this.removeRouteNodeAction));
            this.moveRouteNodeButton = new IconToggleButton((Action)((Object)this.moveRouteNodeAction));
            this.addRouteNodeButton.setAutoHideDisabledButton(true);
            this.removeRouteNodeButton.setAutoHideDisabledButton(true);
            this.moveRouteNodeButton.setAutoHideDisabledButton(true);
            newFrame.addMapMode(this.addRouteNodeButton);
            newFrame.addMapMode(this.removeRouteNodeButton);
            newFrame.addMapMode(this.moveRouteNodeButton);
            this.menu.enableStartItem();
            this.routingDialog = new RoutingDialog();
            newFrame.addToggleDialog((ToggleDialog)this.routingDialog);
        } else {
            this.addRouteNodeAction = null;
            this.removeRouteNodeAction = null;
            this.moveRouteNodeAction = null;
            this.addRouteNodeButton = null;
            this.removeRouteNodeButton = null;
            this.moveRouteNodeButton = null;
            this.routingDialog = null;
        }
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        if (newLayer instanceof RoutingLayer) {
            this.menu.enableRestOfItems();
            if (this.routingDialog != null) {
                this.routingDialog.showDialog();
                this.routingDialog.refresh();
            }
        } else {
            this.menu.disableRestOfItems();
            if (this.routingDialog != null) {
                this.routingDialog.hideDialog();
            }
        }
    }

    public void layerAdded(Layer newLayer) {
        if (newLayer instanceof RoutingLayer) {
            this.menu.enableRestOfItems();
            Main.map.mapView.moveLayer(newLayer, 0);
            logger.debug((Object)"Added routing layer.");
        }
    }

    public void layerRemoved(Layer oldLayer) {
        if (oldLayer instanceof RoutingLayer & this.layers.size() == 1) {
            this.addRouteNodeButton.setVisible(false);
            this.removeRouteNodeButton.setVisible(false);
            this.moveRouteNodeButton.setVisible(false);
            this.menu.disableRestOfItems();
            this.layers.remove(oldLayer);
            logger.debug((Object)"Removed routing layer.");
        } else if (oldLayer instanceof OsmDataLayer) {
            RoutingLayer[] layersArray = this.layers.toArray(new RoutingLayer[0]);
            for (int i = 0; i < layersArray.length; ++i) {
                if (!layersArray[i].getDataLayer().equals(oldLayer)) continue;
                try {
                    Main.main.removeLayer((Layer)layersArray[i]);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        if (this.routingDialog != null) {
            this.routingDialog.refresh();
        }
    }

    public void processDatasetEvent(AbstractDatasetChangedEvent event) {
    }

    public PreferenceSetting getPreferenceSetting() {
        return this.preferenceSettings;
    }
}

