/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.io.download;

import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.io.download.MapillarySquareDownloadManagerThread;
import org.openstreetmap.josm.tools.I18n;

public class MapillaryDownloader {
    public static final String[] MODES = new String[]{"Automatic", "Semiautomatic", "Manual"};
    public static final int AUTOMATIC = 0;
    public static final int SEMIAUTOMATIC = 1;
    public static final int MANUAL = 2;
    private static ArrayList<Thread> threads = new ArrayList();
    public static final double MAX_AREA = Main.pref.getDouble("mapillary.max-download-area", 0.015);
    public static final String BASE_URL = "https://a.mapillary.com/v2/";
    public static final String CLIENT_ID = "T1Fzd20xZjdtR0s1VDk5OFNIOXpYdzoxNDYyOGRkYzUyYTFiMzgz";
    private static ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(3, 5, 100L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));

    public static void getImages(LatLon minLatLon, LatLon maxLatLon) {
        ConcurrentHashMap<String, Double> queryStringParts = new ConcurrentHashMap<String, Double>();
        queryStringParts.put("min_lat", minLatLon.lat());
        queryStringParts.put("min_lon", minLatLon.lon());
        queryStringParts.put("max_lat", maxLatLon.lat());
        queryStringParts.put("max_lon", maxLatLon.lon());
        MapillaryDownloader.run(new MapillarySquareDownloadManagerThread(queryStringParts));
    }

    private static void run(Thread t) {
        threads.add(t);
        EXECUTOR.execute(t);
    }

    public static void completeView() {
        if (MapillaryDownloader.getMode() != 1 && MapillaryDownloader.getMode() != 2) {
            throw new IllegalStateException("Must be in semiautomatic or manual mode");
        }
        Bounds view = Main.map.mapView.getRealBounds();
        if (view.getArea() > MAX_AREA) {
            return;
        }
        if (MapillaryDownloader.isViewDownloaded(view)) {
            return;
        }
        MapillaryLayer.getInstance().getData().bounds.add(view);
        MapillaryDownloader.getImages(view);
    }

    private static boolean isViewDownloaded(Bounds view) {
        int j;
        int i;
        int n = 15;
        boolean[][] inside = new boolean[n][n];
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                if (!MapillaryDownloader.isInBounds(new LatLon(view.getMinLat() + (view.getMaxLat() - view.getMinLat()) * ((double)i / (double)n), view.getMinLon() + (view.getMaxLon() - view.getMinLon()) * ((double)j / (double)n)))) continue;
                inside[i][j] = true;
            }
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                if (inside[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isInBounds(LatLon latlon) {
        for (Bounds bounds : MapillaryLayer.getInstance().getData().bounds) {
            if (!bounds.contains(latlon)) continue;
            return true;
        }
        return false;
    }

    public static void getImages(Bounds bounds) {
        MapillaryDownloader.getImages(bounds.getMin(), bounds.getMax());
    }

    public static void automaticDownload() {
        MapillaryLayer layer = MapillaryLayer.getInstance();
        if (Main.map.mapView.getEditLayer() == null) {
            return;
        }
        if (MapillaryDownloader.isAreaTooBig()) {
            MapillaryDownloader.tooBigErrorDialog();
            return;
        }
        if (MapillaryDownloader.getMode() != 0) {
            throw new IllegalStateException("Must be in automatic mode.");
        }
        for (Bounds bounds : Main.map.mapView.getEditLayer().data.getDataSourceBounds()) {
            if (layer.getData().bounds.contains(bounds)) continue;
            layer.getData().bounds.add(bounds);
            MapillaryDownloader.getImages(bounds.getMin(), bounds.getMax());
        }
    }

    private static boolean isAreaTooBig() {
        double area = 0.0;
        for (Bounds bounds : Main.map.mapView.getEditLayer().data.getDataSourceBounds()) {
            area += bounds.getArea();
        }
        return area > MAX_AREA;
    }

    public static int getMode() {
        if (Main.pref.get("mapillary.download-mode").equals(MODES[0]) && (MapillaryLayer.INSTANCE == null || !MapillaryLayer.INSTANCE.TEMP_SEMIAUTOMATIC)) {
            return 0;
        }
        if (Main.pref.get("mapillary.download-mode").equals(MODES[1]) || MapillaryLayer.INSTANCE != null && MapillaryLayer.getInstance().TEMP_SEMIAUTOMATIC) {
            return 1;
        }
        if (Main.pref.get("mapillary.download-mode").equals(MODES[2])) {
            return 2;
        }
        if (Main.pref.get("mapillary.download-mode").equals("")) {
            return 0;
        }
        throw new IllegalStateException();
    }

    private static void tooBigErrorDialog() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapillaryDownloader.tooBigErrorDialog();
                }
            });
        } else {
            MapillaryLayer.getInstance().TEMP_SEMIAUTOMATIC = true;
            MapillaryPlugin.setMenuEnabled(MapillaryPlugin.DOWNLOAD_VIEW_MENU, true);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The downloaded OSM area is too big. Download mode has been changed to semiautomatic until the layer is restarted.", (Object[])new Object[0]));
        }
    }

    public static void stopAll() {
        for (Thread t : threads) {
            if (t.isAlive()) {
                System.out.println(t);
            }
            t.interrupt();
        }
        threads.clear();
        EXECUTOR.shutdownNow();
        try {
            EXECUTOR.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Main.error((Throwable)e);
        }
        EXECUTOR = new ThreadPoolExecutor(3, 5, 100L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
    }
}

