/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.history.commands;

import java.util.HashMap;
import java.util.List;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.history.commands.MapillaryCommand;
import org.openstreetmap.josm.plugins.mapillary.history.commands.MapillaryExecutableCommand;
import org.openstreetmap.josm.tools.I18n;

public class CommandDelete
extends MapillaryExecutableCommand {
    private HashMap<MapillaryAbstractImage, Integer> changesHash = new HashMap();

    public CommandDelete(List<MapillaryAbstractImage> images) {
        super(images);
    }

    @Override
    public void sum(MapillaryCommand command) {
    }

    @Override
    public void execute() {
        for (MapillaryAbstractImage img : this.images) {
            this.changesHash.put(img, img.getSequence().getImages().indexOf(img));
            MapillaryLayer.getInstance().getData().remove(img);
        }
    }

    @Override
    public String toString() {
        return I18n.trn((String)"Deleted {0} image", (String)"Deleted {0} images", (long)this.images.size(), (Object[])new Object[]{this.images.size()});
    }

    @Override
    public void undo() {
        for (int i = this.images.size() - 1; i >= 0; --i) {
            MapillaryAbstractImage img = (MapillaryAbstractImage)this.images.get(i);
            MapillaryLayer.getInstance().getData().add(img);
            img.getSequence().getImages().add(this.changesHash.get(img), img);
        }
    }

    @Override
    public void redo() {
        MapillaryLayer.getInstance().getData().remove(this.images);
    }
}

