/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.language.SoundexUtils;

public class Soundex
implements StringEncoder {
    public static final String US_ENGLISH_MAPPING_STRING = "0123012#02245501262301#202";
    private static final char[] US_ENGLISH_MAPPING = "0123012#02245501262301#202".toCharArray();
    public static final Soundex US_ENGLISH = new Soundex();
    @Deprecated
    private int maxLength = 4;
    private final char[] soundexMapping;

    public Soundex() {
        this.soundexMapping = US_ENGLISH_MAPPING;
    }

    public Soundex(char[] mapping) {
        this.soundexMapping = new char[mapping.length];
        System.arraycopy(mapping, 0, this.soundexMapping, 0, mapping.length);
    }

    public Soundex(String mapping) {
        this.soundexMapping = mapping.toCharArray();
    }

    public int difference(String s1, String s2) throws EncoderException {
        return SoundexUtils.difference(this, s1, s2);
    }

    @Override
    public Object encode(Object obj) throws EncoderException {
        if (!(obj instanceof String)) {
            throw new EncoderException("Parameter supplied to Soundex encode is not of type java.lang.String");
        }
        return this.soundex((String)obj);
    }

    @Override
    public String encode(String str) {
        return this.soundex(str);
    }

    @Deprecated
    public int getMaxLength() {
        return this.maxLength;
    }

    private char[] getSoundexMapping() {
        return this.soundexMapping;
    }

    private char map(char ch) {
        int index = ch - 65;
        if (index < 0 || index >= this.getSoundexMapping().length) {
            throw new IllegalArgumentException("The character is not mapped: " + ch);
        }
        return this.getSoundexMapping()[index];
    }

    @Deprecated
    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public String soundex(String str) {
        if (str == null) {
            return null;
        }
        if ((str = SoundexUtils.clean(str)).length() == 0) {
            return str;
        }
        char[] out = new char[]{'0', '0', '0', '0'};
        int incount = 1;
        int count = 1;
        out[0] = str.charAt(0);
        char last = this.map(str.charAt(0));
        while (incount < str.length() && count < out.length) {
            char mapped;
            if ((mapped = this.map(str.charAt(incount++))) == '0') {
                last = mapped;
                continue;
            }
            if (mapped == '#' || mapped == last) continue;
            out[count++] = mapped;
            last = mapped;
        }
        return new String(out);
    }
}

