/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.mapillary.history.MapillaryRecord;
import org.openstreetmap.josm.plugins.mapillary.history.MapillaryRecordListener;
import org.openstreetmap.josm.plugins.mapillary.history.commands.CommandDelete;
import org.openstreetmap.josm.plugins.mapillary.history.commands.MapillaryCommand;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryUtils;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class MapillaryHistoryDialog
extends ToggleDialog
implements MapillaryRecordListener {
    private static final long serialVersionUID = -3019715241209349372L;
    private static MapillaryHistoryDialog INSTANCE;
    private transient UndoRedoSelectionListener undoSelectionListener;
    private transient UndoRedoSelectionListener redoSelectionListener;
    private final DefaultTreeModel undoTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
    private final DefaultTreeModel redoTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
    private final JTree undoTree = new JTree(this.undoTreeModel);
    private final JTree redoTree = new JTree(this.redoTreeModel);
    private JSeparator separator = new JSeparator();
    private Component spacer = Box.createRigidArea(new Dimension(0, 3));
    private SideButton undoButton;
    private SideButton redoButton;
    private ConcurrentHashMap<Object, MapillaryCommand> map;

    private MapillaryHistoryDialog() {
        super(I18n.tr((String)"Mapillary history", (Object[])new Object[0]), "mapillaryhistory.png", I18n.tr((String)"Open Mapillary history dialog", (Object[])new Object[0]), Shortcut.registerShortcut((String)I18n.tr((String)"Mapillary history", (Object[])new Object[0]), (String)I18n.tr((String)"Open Mapillary history dialog", (Object[])new Object[0]), (int)77, (int)5000), 200);
        MapillaryRecord.getInstance().addListener(this);
        this.map = new ConcurrentHashMap();
        this.undoTree.expandRow(0);
        this.undoTree.setShowsRootHandles(true);
        this.undoTree.setRootVisible(false);
        this.undoTree.setCellRenderer(new MapillaryCellRenderer());
        this.undoTree.getSelectionModel().setSelectionMode(1);
        this.undoTree.addMouseListener(new MouseEventHandler());
        this.undoSelectionListener = new UndoRedoSelectionListener(this.undoTree);
        this.undoTree.getSelectionModel().addTreeSelectionListener(this.undoSelectionListener);
        this.redoTree.expandRow(0);
        this.redoTree.setCellRenderer(new MapillaryCellRenderer());
        this.redoTree.setShowsRootHandles(true);
        this.redoTree.setRootVisible(false);
        this.redoTree.getSelectionModel().setSelectionMode(1);
        this.redoTree.addMouseListener(new MouseEventHandler());
        this.redoSelectionListener = new UndoRedoSelectionListener(this.redoTree);
        this.redoTree.getSelectionModel().addTreeSelectionListener(this.redoSelectionListener);
        JPanel treesPanel = new JPanel(new GridBagLayout());
        treesPanel.add(this.spacer, GBC.eol());
        this.spacer.setVisible(false);
        treesPanel.add((Component)this.undoTree, GBC.eol().fill(2));
        this.separator.setVisible(false);
        treesPanel.add((Component)this.separator, GBC.eol().fill(2));
        treesPanel.add((Component)this.redoTree, GBC.eol().fill(2));
        treesPanel.add(Box.createRigidArea(new Dimension(0, 0)), GBC.std().weight(0.0, 1.0));
        treesPanel.setBackground(this.redoTree.getBackground());
        this.undoButton = new SideButton((Action)new UndoAction());
        this.redoButton = new SideButton((Action)new RedoAction());
        this.createLayout(treesPanel, true, Arrays.asList(this.undoButton, this.redoButton));
    }

    public static MapillaryHistoryDialog getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MapillaryHistoryDialog();
        }
        return INSTANCE;
    }

    private void buildTree() {
        DefaultMutableTreeNode node;
        this.redoButton.setEnabled(true);
        this.undoButton.setEnabled(true);
        ArrayList<MapillaryCommand> commands = MapillaryRecord.getInstance().commandList;
        int position = MapillaryRecord.getInstance().position;
        ArrayList<Object> undoCommands = new ArrayList();
        if (position >= 0) {
            undoCommands = new ArrayList<MapillaryCommand>(commands.subList(0, position + 1));
        } else {
            this.undoButton.setEnabled(false);
        }
        ArrayList<Object> redoCommands = new ArrayList();
        if (commands.size() > 0 && position + 1 < commands.size()) {
            redoCommands = new ArrayList<MapillaryCommand>(commands.subList(position + 1, commands.size()));
        } else {
            this.redoButton.setEnabled(false);
        }
        DefaultMutableTreeNode redoRoot = new DefaultMutableTreeNode();
        DefaultMutableTreeNode undoRoot = new DefaultMutableTreeNode();
        this.map.clear();
        for (MapillaryCommand mapillaryCommand : undoCommands) {
            if (mapillaryCommand == null) continue;
            node = new DefaultMutableTreeNode(mapillaryCommand.toString());
            this.map.put(node, mapillaryCommand);
            undoRoot.add(node);
        }
        for (MapillaryCommand mapillaryCommand : redoCommands) {
            if (mapillaryCommand == null) continue;
            node = new DefaultMutableTreeNode(mapillaryCommand.toString());
            this.map.put(node, mapillaryCommand);
            redoRoot.add(node);
        }
        this.separator.setVisible(!undoCommands.isEmpty() || !redoCommands.isEmpty());
        this.spacer.setVisible(undoCommands.isEmpty() && !redoCommands.isEmpty());
        this.undoTreeModel.setRoot(undoRoot);
        this.redoTreeModel.setRoot(redoRoot);
    }

    @Override
    public void recordChanged() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapillaryHistoryDialog.this.recordChanged();
                }
            });
        } else {
            this.buildTree();
        }
    }

    public static void destroyInstance() {
        INSTANCE = null;
    }

    private class UndoRedoSelectionListener
    implements TreeSelectionListener {
        private JTree source;

        private UndoRedoSelectionListener(JTree source) {
            this.source = source;
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (this.source == MapillaryHistoryDialog.this.undoTree) {
                MapillaryHistoryDialog.this.redoTree.getSelectionModel().removeTreeSelectionListener(MapillaryHistoryDialog.this.redoSelectionListener);
                MapillaryHistoryDialog.this.redoTree.clearSelection();
                MapillaryHistoryDialog.this.redoTree.getSelectionModel().addTreeSelectionListener(MapillaryHistoryDialog.this.redoSelectionListener);
            }
            if (this.source == MapillaryHistoryDialog.this.redoTree) {
                MapillaryHistoryDialog.this.undoTree.getSelectionModel().removeTreeSelectionListener(MapillaryHistoryDialog.this.undoSelectionListener);
                MapillaryHistoryDialog.this.undoTree.clearSelection();
                MapillaryHistoryDialog.this.undoTree.getSelectionModel().addTreeSelectionListener(MapillaryHistoryDialog.this.undoSelectionListener);
            }
        }
    }

    private class MouseEventHandler
    implements MouseListener {
        private MouseEventHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2) {
                if (MapillaryHistoryDialog.this.undoTree.getSelectionPath() != null) {
                    MapillaryCommand cmd = (MapillaryCommand)MapillaryHistoryDialog.this.map.get(MapillaryHistoryDialog.this.undoTree.getSelectionPath().getLastPathComponent());
                    if (!(cmd instanceof CommandDelete)) {
                        MapillaryUtils.showPictures(cmd.images, true);
                    }
                } else {
                    MapillaryUtils.showPictures(((MapillaryCommand)((MapillaryHistoryDialog)MapillaryHistoryDialog.this).map.get((Object)((MapillaryHistoryDialog)MapillaryHistoryDialog.this).redoTree.getSelectionPath().getLastPathComponent())).images, true);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private static class MapillaryCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -3129520241562296901L;

        private MapillaryCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setIcon(ImageProvider.get((String)"data/node.png"));
            return this;
        }
    }

    private class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -2761935780353053512L;

        public RedoAction() {
            this.putValue("Name", I18n.tr((String)"Redo", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"redo"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MapillaryRecord.getInstance().redo();
        }
    }

    private class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = -6435832206342007269L;

        public UndoAction() {
            this.putValue("Name", I18n.tr((String)"Undo", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"undo"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MapillaryRecord.getInstance().undo();
        }
    }
}

