/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.downloads;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.downloads.MapillaryImageInfoDownloaderThread;
import org.openstreetmap.josm.plugins.mapillary.downloads.MapillarySequenceDownloadThread;
import org.openstreetmap.josm.plugins.mapillary.downloads.MapillarySignDownloaderThread;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryFilterDialog;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryMainDialog;
import org.openstreetmap.josm.tools.I18n;

public class MapillarySquareDownloadManagerThread
extends Thread {
    private final String urlImages;
    private final String urlSequences;
    private final String urlSigns;
    private final MapillaryLayer layer;
    public boolean imagesAdded = false;

    public MapillarySquareDownloadManagerThread(String urlImages, String urlSequences, String urlSigns, MapillaryLayer layer) {
        this.urlImages = urlImages;
        this.urlSequences = urlSequences;
        this.urlSigns = urlSigns;
        this.layer = layer;
    }

    @Override
    public void run() {
        Main.map.statusLine.setHelpText(I18n.tr((String)"Downloading images from Mapillary", (Object[])new Object[0]));
        try {
            this.downloadSequences();
            if (this.imagesAdded) {
                Main.map.statusLine.setHelpText(I18n.tr((String)"Downloading image's information", (Object[])new Object[0]));
                this.completeImages();
                MapillaryMainDialog.getInstance().updateTitle();
                Main.map.statusLine.setHelpText(I18n.tr((String)"Downloading signs", (Object[])new Object[0]));
                this.downloadSigns();
            }
        }
        catch (InterruptedException e) {
            Main.error((Throwable)e);
        }
        this.layer.updateHelpText();
        this.layer.data.dataUpdated();
        MapillaryFilterDialog.getInstance().refresh();
        MapillaryMainDialog.getInstance().updateImage();
    }

    private void downloadSequences() throws InterruptedException {
        ThreadPoolExecutor ex = new ThreadPoolExecutor(3, 5, 25L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(5));
        int page = 0;
        while (!ex.isShutdown()) {
            ex.execute(new MapillarySequenceDownloadThread(ex, this.urlSequences + "&page=" + page + "&limit=10", this.layer, this));
            while (ex.getQueue().remainingCapacity() == 0) {
                Thread.sleep(500L);
            }
            ++page;
        }
        ex.awaitTermination(15L, TimeUnit.SECONDS);
        this.layer.data.dataUpdated();
    }

    private void completeImages() throws InterruptedException {
        ThreadPoolExecutor ex = new ThreadPoolExecutor(3, 5, 25L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(5));
        int page = 0;
        while (!ex.isShutdown()) {
            ex.execute(new MapillaryImageInfoDownloaderThread(ex, this.urlImages + "&page=" + page + "&limit=20", this.layer));
            while (ex.getQueue().remainingCapacity() == 0) {
                Thread.sleep(100L);
            }
            ++page;
        }
        ex.awaitTermination(15L, TimeUnit.SECONDS);
    }

    private void downloadSigns() throws InterruptedException {
        ThreadPoolExecutor ex = new ThreadPoolExecutor(3, 5, 25L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(5));
        int page = 0;
        while (!ex.isShutdown()) {
            ex.execute(new MapillarySignDownloaderThread(ex, this.urlSigns + "&page=" + page + "&limit=20", this.layer));
            while (ex.getQueue().remainingCapacity() == 0) {
                Thread.sleep(100L);
            }
            ++page;
        }
        ex.awaitTermination(15L, TimeUnit.SECONDS);
    }
}

