/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.mapillary.MapillarySequence;

public abstract class MapillaryAbstractImage {
    protected long capturedAt;
    private MapillarySequence sequence;
    public final LatLon latLon;
    public final double ca;
    public LatLon tempLatLon;
    public LatLon movingLatLon;
    public double tempCa;
    protected double movingCa;
    private boolean visible;

    public MapillaryAbstractImage(double lat, double lon, double ca) {
        this.tempLatLon = this.latLon = new LatLon(lat, lon);
        this.movingLatLon = this.latLon;
        this.ca = ca;
        this.tempCa = ca;
        this.movingCa = ca;
        this.visible = true;
    }

    public double getCa() {
        return this.movingCa;
    }

    public long getCapturedAt() {
        return this.capturedAt;
    }

    public String getDate() {
        String format = "";
        format = Main.pref.getBoolean("iso.dates") ? format + "yyyy-MM-dd" : format + "dd/MM/yyyy";
        if (Main.pref.getBoolean("mapillary.display-hour", true)) {
            format = Main.pref.getBoolean("mapillary.format-24") ? format + " - HH:mm:ss (z)" : format + " - h:mm:ss a (z)";
        }
        return this.getDate(format);
    }

    public String getDate(String format) {
        Date date = new Date(this.getCapturedAt());
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        formatter.setTimeZone(Calendar.getInstance().getTimeZone());
        return formatter.format(date);
    }

    public LatLon getLatLon() {
        return this.movingLatLon;
    }

    public MapillarySequence getSequence() {
        if (this.sequence == null) {
            this.sequence = new MapillarySequence();
            this.sequence.add(this);
        }
        return this.sequence;
    }

    public double getTempCa() {
        return this.tempCa;
    }

    public LatLon getTempLatLon() {
        return this.tempLatLon;
    }

    public boolean isModified() {
        return this.getLatLon() != this.latLon || this.getCa() != this.ca;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void move(double x, double y) {
        this.movingLatLon = new LatLon(this.tempLatLon.getY() + y, this.tempLatLon.getX() + x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapillaryAbstractImage next() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.getSequence() == null) {
                return null;
            }
            return this.getSequence().next(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapillaryAbstractImage previous() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.getSequence() == null) {
                return null;
            }
            return this.getSequence().previous(this);
        }
    }

    public void setCapturedAt(long capturedAt) {
        this.capturedAt = capturedAt;
    }

    public void setSequence(MapillarySequence sequence) {
        this.sequence = sequence;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void stopMoving() {
        this.tempLatLon = this.movingLatLon;
        this.tempCa = this.movingCa;
    }

    public void turn(double ca) {
        this.movingCa = this.tempCa + ca;
    }
}

