/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.matrix;

import java.awt.geom.AffineTransform;
import java.io.Serializable;
import org.ejml.UtilEjml;
import org.ejml.alg.fixed.FixedOps3;
import org.ejml.data.FixedMatrix3x3_64F;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.matrix.SingularMatrixException;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.resources.i18n.Errors;
import org.opengis.referencing.operation.Matrix;

public class Matrix3
implements XMatrix,
Serializable {
    private static final long serialVersionUID = 8902061778871586612L;
    public static final int SIZE = 3;
    FixedMatrix3x3_64F mat;

    public Matrix3() {
        this.mat = new FixedMatrix3x3_64F();
        this.setIdentity();
    }

    public Matrix3(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.mat = new FixedMatrix3x3_64F(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public Matrix3(AffineTransform transform) {
        this.mat = new FixedMatrix3x3_64F();
        this.setMatrix(transform);
    }

    public Matrix3(Matrix matrix) {
        this.mat = new FixedMatrix3x3_64F();
        if (matrix.getNumRow() != 3 || matrix.getNumCol() != 3) {
            throw new IllegalArgumentException(Errors.format(70));
        }
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 3; ++i) {
                this.setElement(j, i, matrix.getElement(j, i));
            }
        }
    }

    private FixedMatrix3x3_64F internal(Matrix matrix) {
        if (matrix instanceof Matrix3) {
            return ((Matrix3)matrix).mat;
        }
        FixedMatrix3x3_64F a = new FixedMatrix3x3_64F(matrix.getElement(0, 0), matrix.getElement(0, 1), matrix.getElement(0, 2), matrix.getElement(1, 0), matrix.getElement(1, 1), matrix.getElement(1, 2), matrix.getElement(2, 0), matrix.getElement(2, 1), matrix.getElement(2, 2));
        return a;
    }

    @Override
    public final int getNumRow() {
        return 3;
    }

    @Override
    public final int getNumCol() {
        return 3;
    }

    public final boolean isNaN() {
        return Double.isNaN(this.mat.a11) || Double.isNaN(this.mat.a12) || Double.isNaN(this.mat.a13) || Double.isNaN(this.mat.a21) || Double.isNaN(this.mat.a22) || Double.isNaN(this.mat.a23) || Double.isNaN(this.mat.a31) || Double.isNaN(this.mat.a32) || Double.isNaN(this.mat.a33);
    }

    public void setMatrix(AffineTransform transform) {
        this.mat.a11 = transform.getScaleX();
        this.mat.a12 = transform.getShearX();
        this.mat.a13 = transform.getTranslateX();
        this.mat.a21 = transform.getShearY();
        this.mat.a22 = transform.getScaleY();
        this.mat.a23 = transform.getTranslateY();
        this.mat.a31 = 0.0;
        this.mat.a32 = 0.0;
        this.mat.a33 = 1.0;
    }

    public boolean equalsAffine(AffineTransform transform) {
        return this.mat.a11 == transform.getScaleX() && this.mat.a12 == transform.getShearX() && this.mat.a13 == transform.getTranslateX() && this.mat.a21 == transform.getShearY() && this.mat.a22 == transform.getScaleY() && this.mat.a23 == transform.getTranslateY() && this.mat.a31 == 0.0 && this.mat.a32 == 0.0 && this.mat.a33 == 1.0;
    }

    public Matrix3 clone() {
        return new Matrix3(this);
    }

    @Override
    public final boolean isAffine() {
        return this.mat.a31 == 0.0 && this.mat.a32 == 0.0 && this.mat.a33 == 1.0;
    }

    @Override
    public void negate() {
        FixedOps3.changeSign((FixedMatrix3x3_64F)this.mat);
    }

    @Override
    public void negate(Matrix matrix) {
        FixedMatrix3x3_64F a = this.internal(matrix);
        FixedOps3.changeSign((FixedMatrix3x3_64F)a);
        this.mat = a;
    }

    @Override
    public void transpose() {
        FixedOps3.transpose((FixedMatrix3x3_64F)this.mat);
    }

    @Override
    public void transpose(Matrix matrix) {
        FixedMatrix3x3_64F a = this.internal(matrix);
        FixedOps3.transpose((FixedMatrix3x3_64F)a, (FixedMatrix3x3_64F)this.mat);
    }

    @Override
    public void invert() {
        FixedMatrix3x3_64F ret = new FixedMatrix3x3_64F();
        boolean success = FixedOps3.invert((FixedMatrix3x3_64F)this.mat, (FixedMatrix3x3_64F)ret);
        if (!success) {
            throw new SingularMatrixException("Could not invert, possible singular matrix?");
        }
        this.mat = ret;
    }

    @Override
    public void invert(Matrix matrix) throws SingularMatrixException {
        FixedMatrix3x3_64F a = this.internal(matrix);
        boolean success = FixedOps3.invert((FixedMatrix3x3_64F)a, (FixedMatrix3x3_64F)this.mat);
        if (!success) {
            throw new SingularMatrixException("Could not invert, possible singular matrix?");
        }
        this.mat = a;
    }

    @Override
    public double getElement(int row, int column) {
        return this.mat.get(row, column);
    }

    @Override
    public void setColumn(int column, double ... values) {
        if (values.length != this.mat.getNumCols()) {
            throw new IllegalArgumentException("Call setRow received an array of length " + values.length + ".  " + "The dimensions of the matrix is " + this.mat.getNumRows() + " by " + this.mat.getNumCols() + ".");
        }
        for (int i = 0; i < values.length; ++i) {
            this.mat.set(i, column, values[i]);
        }
    }

    @Override
    public void setRow(int row, double ... values) {
        if (values.length != this.mat.getNumCols()) {
            throw new IllegalArgumentException("Call setRow received an array of length " + values.length + ".  " + "The dimensions of the matrix is " + this.mat.getNumRows() + " by " + this.mat.getNumCols() + ".");
        }
        for (int i = 0; i < values.length; ++i) {
            this.mat.set(row, i, values[i]);
        }
    }

    public void setElement(int row, int column, double value) {
        this.mat.set(row, column, value);
    }

    @Override
    public void setZero() {
        FixedOps3.fill((FixedMatrix3x3_64F)this.mat, (double)0.0);
    }

    @Override
    public void setIdentity() {
        FixedOps3.setIdentity((FixedMatrix3x3_64F)this.mat);
    }

    public final boolean isIdentity() {
        int numCol;
        int numRow = this.getNumRow();
        if (numRow != (numCol = this.getNumCol())) {
            return false;
        }
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                if (this.getElement(j, i) == (i == j ? 1.0 : 0.0)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final boolean isIdentity(double tolerance) {
        return GeneralMatrix.isIdentity(this, tolerance);
    }

    @Override
    public final void multiply(Matrix matrix) {
        this.mul(matrix);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.mat == null) {
            return 31 * result;
        }
        result = 31 * result + 3;
        result = 31 * result + 3;
        long bits = Double.doubleToRawLongBits(this.mat.a11);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = Double.doubleToRawLongBits(this.mat.a12);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = Double.doubleToRawLongBits(this.mat.a13);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = Double.doubleToRawLongBits(this.mat.a21);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = Double.doubleToRawLongBits(this.mat.a22);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = Double.doubleToRawLongBits(this.mat.a23);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = Double.doubleToRawLongBits(this.mat.a31);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = Double.doubleToRawLongBits(this.mat.a32);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = Double.doubleToRawLongBits(this.mat.a33);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Matrix3 other = (Matrix3)obj;
        return this.equals(other, 0.0);
    }

    @Override
    public boolean equals(Matrix matrix, double tolerance) {
        return GeneralMatrix.epsilonEquals(this, matrix, tolerance);
    }

    public final AffineTransform toAffineTransform2D() throws IllegalStateException {
        if (this.isAffine()) {
            return new AffineTransform(this.getElement(0, 0), this.getElement(1, 0), this.getElement(0, 1), this.getElement(1, 1), this.getElement(0, 2), this.getElement(1, 2));
        }
        throw new IllegalStateException(Errors.format(118));
    }

    public String toString() {
        return GeneralMatrix.toString(this);
    }

    @Override
    public void getColumn(int col, double[] array) {
        for (int j = 0; j < array.length; ++j) {
            array[j] = this.mat.get(j, col);
        }
    }

    @Override
    public void mul(double scalar) {
        FixedOps3.scale((double)scalar, (FixedMatrix3x3_64F)this.mat);
    }

    @Override
    public void mul(double scalar, Matrix matrix) {
        FixedMatrix3x3_64F ret = new FixedMatrix3x3_64F();
        FixedOps3.scale((double)scalar, (FixedMatrix3x3_64F)this.internal(matrix), (FixedMatrix3x3_64F)ret);
        this.mat = ret;
    }

    @Override
    public void getRow(int row, double[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.mat.get(row, i);
        }
    }

    @Override
    public final void mul(Matrix matrix) {
        FixedMatrix3x3_64F b = this.internal(matrix);
        FixedMatrix3x3_64F ret = new FixedMatrix3x3_64F();
        FixedOps3.mult((FixedMatrix3x3_64F)this.mat, (FixedMatrix3x3_64F)b, (FixedMatrix3x3_64F)ret);
        this.mat = ret;
    }

    @Override
    public void mul(Matrix matrix1, Matrix matrix2) {
        FixedMatrix3x3_64F a = this.internal(matrix1);
        FixedMatrix3x3_64F b = this.internal(matrix2);
        if (a == this.mat || b == this.mat) {
            this.mat = new FixedMatrix3x3_64F();
        }
        FixedOps3.mult((FixedMatrix3x3_64F)a, (FixedMatrix3x3_64F)b, (FixedMatrix3x3_64F)this.mat);
    }

    @Override
    public void sub(double scalar) {
        this.mat.a11 -= scalar;
        this.mat.a12 -= scalar;
        this.mat.a12 -= scalar;
        this.mat.a21 -= scalar;
        this.mat.a22 -= scalar;
        this.mat.a22 -= scalar;
        this.mat.a31 -= scalar;
        this.mat.a32 -= scalar;
        this.mat.a32 -= scalar;
    }

    @Override
    public void sub(double scalar, Matrix matrix) {
        FixedMatrix3x3_64F a = this.internal(matrix);
        this.mat.a11 = scalar - a.a11;
        this.mat.a12 = scalar - a.a12;
        this.mat.a12 = scalar - a.a13;
        this.mat.a21 = scalar - a.a21;
        this.mat.a22 = scalar - a.a22;
        this.mat.a22 = scalar - a.a23;
        this.mat.a31 = scalar - a.a31;
        this.mat.a32 = scalar - a.a32;
        this.mat.a32 = scalar - a.a33;
    }

    @Override
    public void sub(Matrix matrix) {
        FixedMatrix3x3_64F a = this.internal(matrix);
        this.mat.a11 -= a.a11;
        this.mat.a12 -= a.a12;
        this.mat.a12 -= a.a13;
        this.mat.a21 -= a.a21;
        this.mat.a22 -= a.a22;
        this.mat.a22 -= a.a23;
        this.mat.a31 -= a.a31;
        this.mat.a32 -= a.a32;
        this.mat.a32 -= a.a33;
    }

    @Override
    public void sub(Matrix matrix1, Matrix matrix2) {
        FixedMatrix3x3_64F a = this.internal(matrix1);
        FixedMatrix3x3_64F b = this.internal(matrix2);
        this.mat.a11 = a.a11 - b.a11;
        this.mat.a12 = a.a12 - b.a12;
        this.mat.a12 = a.a13 - b.a13;
        this.mat.a21 = a.a21 - b.a21;
        this.mat.a22 = a.a22 - b.a22;
        this.mat.a22 = a.a23 - b.a23;
        this.mat.a31 = a.a31 - b.a31;
        this.mat.a32 = a.a32 - b.a32;
        this.mat.a32 = a.a33 - b.a33;
    }

    public void set(double[] matrix) {
        this.mat.a11 = matrix[0];
        this.mat.a12 = matrix[1];
        this.mat.a13 = matrix[2];
        this.mat.a21 = matrix[3];
        this.mat.a22 = matrix[4];
        this.mat.a23 = matrix[5];
        this.mat.a31 = matrix[6];
        this.mat.a32 = matrix[7];
        this.mat.a33 = matrix[8];
    }

    @Override
    public void add(double scalar) {
        this.mat.a11 += scalar;
        this.mat.a12 += scalar;
        this.mat.a12 += scalar;
        this.mat.a21 += scalar;
        this.mat.a22 += scalar;
        this.mat.a22 += scalar;
        this.mat.a31 += scalar;
        this.mat.a32 += scalar;
        this.mat.a32 += scalar;
    }

    @Override
    public void add(double scalar, XMatrix matrix) {
        FixedMatrix3x3_64F a = this.internal(matrix);
        this.mat.a11 = scalar + a.a11;
        this.mat.a12 = scalar + a.a12;
        this.mat.a12 = scalar + a.a13;
        this.mat.a21 = scalar + a.a21;
        this.mat.a22 = scalar + a.a22;
        this.mat.a22 = scalar + a.a23;
        this.mat.a31 = scalar + a.a31;
        this.mat.a32 = scalar + a.a32;
        this.mat.a32 = scalar + a.a33;
    }

    @Override
    public void add(XMatrix matrix) {
        FixedOps3.add((FixedMatrix3x3_64F)this.mat, (FixedMatrix3x3_64F)this.internal(matrix), (FixedMatrix3x3_64F)this.mat);
    }

    @Override
    public void add(XMatrix matrix1, XMatrix matrix2) {
        FixedMatrix3x3_64F a = this.internal(matrix1);
        FixedMatrix3x3_64F b = this.internal(matrix2);
        FixedOps3.add((FixedMatrix3x3_64F)a, (FixedMatrix3x3_64F)b, (FixedMatrix3x3_64F)this.mat);
    }

    @Override
    public double determinate() {
        double det = FixedOps3.det((FixedMatrix3x3_64F)this.mat);
        if (UtilEjml.isUncountable((double)det)) {
            return 0.0;
        }
        return det;
    }
}

