/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.io.UploadDialog;
import reverter.RevertChangesetCommand;
import reverter.ReverterPlugin;

public class ReverterUploadHook
implements UploadHook {
    String pluginString;

    public ReverterUploadHook(ReverterPlugin plugin) {
        this.pluginString = "reverter_plugin/" + plugin.getPluginInformation().version;
    }

    public boolean checkUpload(APIDataSet apiDataSet) {
        UploadDialog ud;
        Map tags;
        String created_by;
        if (!ReverterPlugin.reverterUsed) {
            return true;
        }
        boolean hasRevertions = false;
        for (Command cmd : Main.main.undoRedo.commands) {
            if (!(cmd instanceof RevertChangesetCommand)) continue;
            hasRevertions = true;
            break;
        }
        if ((created_by = (String)(tags = (ud = UploadDialog.getUploadDialog()).getDefaultChangesetTags()).get("created_by")) == null || "".equals(created_by)) {
            if (hasRevertions) {
                tags.put("created_by", Version.getInstance().getAgentString(false) + ";" + this.pluginString);
                ud.setDefaultChangesetTags(tags);
            }
            return true;
        }
        if (hasRevertions) {
            if (!created_by.contains(this.pluginString)) {
                tags.put("created_by", created_by + ";" + this.pluginString);
            }
        } else if (created_by.contains(";" + this.pluginString)) {
            tags.put("created_by", created_by.replace(";" + this.pluginString, ""));
        }
        ud.setDefaultChangesetTags(tags);
        return true;
    }
}

