/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import reverter.ChangesetIdsTextField;
import reverter.ChangesetReverter;

public class ChangesetIdQuery
extends ExtendedDialog {
    private final JPanel panel = new JPanel(new GridBagLayout());
    private final ChangesetIdsTextField tcid = new ChangesetIdsTextField();
    private final HistoryComboBox cbId = new HistoryComboBox();
    private final ButtonGroup bgRevertType = new ButtonGroup();
    private final JRadioButton rbFull = new JRadioButton(I18n.tr((String)"Revert changeset fully", (Object[])new Object[0]));
    private final JRadioButton rbSelection = new JRadioButton(I18n.tr((String)"Revert selection only", (Object[])new Object[0]));
    private final JRadioButton rbSelectionUndelete = new JRadioButton(I18n.tr((String)"Revert selection and restore deleted objects", (Object[])new Object[0]));
    private final JCheckBox cbNewLayer = new JCheckBox(I18n.tr((String)"Download as new layer", (Object[])new Object[0]));

    public Collection<Integer> getIdsInReverseOrder() {
        return this.tcid.getIdsInReverseOrder();
    }

    public boolean isNewLayerRequired() {
        return this.cbNewLayer.isSelected();
    }

    public ChangesetReverter.RevertType getRevertType() {
        if (this.rbFull.isSelected()) {
            return ChangesetReverter.RevertType.FULL;
        }
        if (this.rbSelection.isSelected()) {
            return ChangesetReverter.RevertType.SELECTION;
        }
        if (this.rbSelectionUndelete.isSelected()) {
            return ChangesetReverter.RevertType.SELECTION_WITH_UNDELETE;
        }
        return null;
    }

    public ChangesetIdQuery() {
        super(Main.parent, I18n.tr((String)"Revert changeset", (Object[])new Object[0]), new String[]{I18n.tr((String)"Revert", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])}, true);
        this.contentInsets = new Insets(10, 10, 10, 5);
        this.panel.add(new JLabel(I18n.tr((String)"Changeset id:", (Object[])new Object[0])));
        this.cbId.setEditor((ComboBoxEditor)new BasicComboBoxEditor(){

            @Override
            protected JTextField createEditorComponent() {
                return ChangesetIdQuery.this.tcid;
            }
        });
        this.cbId.setToolTipText(I18n.tr((String)"Enter the ID of the changeset that should be reverted", (Object[])new Object[0]));
        this.restoreChangesetsHistory(this.cbId);
        this.tcid.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(10, 0, false));
        this.panel.add((Component)this.cbId, GBC.eol().fill(2));
        this.bgRevertType.add(this.rbFull);
        this.bgRevertType.add(this.rbSelection);
        this.bgRevertType.add(this.rbSelectionUndelete);
        this.rbFull.setSelected(true);
        this.panel.add((Component)this.rbFull, GBC.eol().insets(0, 10, 0, 0).fill(2));
        this.panel.add((Component)this.rbSelection, GBC.eol().fill(2));
        this.panel.add((Component)this.rbSelectionUndelete, GBC.eol().fill(2));
        this.cbNewLayer.setToolTipText(I18n.tr((String)"<html>Select to download data into a new data layer.<br>Unselect to download into the currently active data layer.</html>", (Object[])new Object[0]));
        this.panel.add((Component)this.cbNewLayer, GBC.eol().fill(2));
    }

    public void setupDialog() {
        this.setContent(this.panel, false);
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        this.setDefaultButton(1);
        this.addWindowListener(new InternalWindowListener());
        super.setupDialog();
        DataSet ds = Main.main.getCurrentDataSet();
        if (ds == null) {
            this.cbNewLayer.setSelected(true);
            this.cbNewLayer.setEnabled(false);
        }
        if (ds == null || ds.getAllSelected().isEmpty()) {
            this.rbSelection.setEnabled(false);
            this.rbSelectionUndelete.setEnabled(false);
        }
        this.tcid.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.idChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.idChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.idChanged();
            }

            private void idChanged() {
                if (ChangesetIdQuery.this.tcid.hasFocus()) {
                    ((JButton)ChangesetIdQuery.this.buttons.get(0)).setEnabled(ChangesetIdQuery.this.tcid.readIds());
                }
            }
        });
        if (Main.pref.getBoolean("downloadchangeset.autopaste", true)) {
            this.tcid.tryToPasteFromClipboard();
        }
        ((JButton)this.buttons.get(0)).setEnabled(this.tcid.readIds());
    }

    protected void restoreChangesetsHistory(HistoryComboBox cbHistory) {
        LinkedList cmtHistory = new LinkedList(Main.pref.getCollection(((Object)((Object)this)).getClass().getName() + ".changesetsHistory", new LinkedList()));
        Collections.reverse(cmtHistory);
        cbHistory.setPossibleItems(cmtHistory);
    }

    protected void remindChangesetsHistory(HistoryComboBox cbHistory) {
        cbHistory.addCurrentItemToHistory();
        Main.pref.putCollection(((Object)((Object)this)).getClass().getName() + ".changesetsHistory", (Collection)cbHistory.getHistory());
    }

    private class InternalWindowListener
    implements WindowListener {
        private InternalWindowListener() {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            if (e != null && e.getComponent() == ChangesetIdQuery.this && ChangesetIdQuery.this.getValue() == 1) {
                if (!ChangesetIdQuery.this.tcid.readIds()) {
                    return;
                }
                ChangesetIdQuery.this.remindChangesetsHistory(ChangesetIdQuery.this.cbId);
            }
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }
    }
}

