/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public final class CommonUtils {
    private static final String UNABLE_TO_FIND_EXCEPTION_PREFIX = "Unable to find: ";

    private CommonUtils() {
    }

    public static boolean matchesFileExtension(File file, String ... fileExtensions) {
        boolean result = false;
        if (fileExtensions == null || fileExtensions.length == 0) {
            result = true;
        } else {
            String[] withDotExtensions = new String[fileExtensions.length];
            for (int i = 0; i < fileExtensions.length; ++i) {
                String extension = fileExtensions[i];
                withDotExtensions[i] = CommonUtils.startsWithChar(extension, '.') ? extension : "." + extension;
            }
            String fileName = file.getName();
            for (String fileExtension : withDotExtensions) {
                if (!fileName.endsWith(fileExtension)) continue;
                result = true;
            }
        }
        return result;
    }

    public static boolean hasWhitespaceBefore(int index, String line) {
        for (int i = 0; i < index; ++i) {
            if (Character.isWhitespace(line.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int lengthMinusTrailingWhitespace(String line) {
        int len = line.length();
        for (int i = len - 1; i >= 0 && Character.isWhitespace(line.charAt(i)); --i) {
            --len;
        }
        return len;
    }

    public static int lengthExpandedTabs(String inputString, int toIdx, int tabWidth) {
        int len = 0;
        for (int idx = 0; idx < toIdx; ++idx) {
            if (inputString.charAt(idx) == '\t') {
                len = (len / tabWidth + 1) * tabWidth;
                continue;
            }
            ++len;
        }
        return len;
    }

    public static boolean isPatternValid(String pattern) {
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException ignored) {
            return false;
        }
        return true;
    }

    public static Pattern createPattern(String pattern) {
        try {
            return Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("Failed to initialise regular expression " + pattern, e);
        }
    }

    public static String baseClassName(String type) {
        int i = type.lastIndexOf(46);
        if (i == -1) {
            return type;
        }
        return type.substring(i + 1);
    }

    public static String relativizeAndNormalizePath(String baseDirectory, String path) {
        if (baseDirectory == null) {
            return path;
        }
        Path pathAbsolute = Paths.get(path, new String[0]).normalize();
        Path pathBase = Paths.get(baseDirectory, new String[0]).normalize();
        return pathBase.relativize(pathAbsolute).toString();
    }

    public static boolean startsWithChar(String value, char prefix) {
        return !value.isEmpty() && value.charAt(0) == prefix;
    }

    public static boolean endsWithChar(String value, char suffix) {
        return !value.isEmpty() && value.charAt(value.length() - 1) == suffix;
    }

    public static Constructor<?> getConstructor(Class<?> targetClass, Class<?> ... parameterTypes) {
        try {
            return targetClass.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static <T> T invokeConstructor(Constructor<T> constructor, Object ... parameters) {
        try {
            return constructor.newInstance(parameters);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot close the stream", e);
        }
    }

    public static URI getUriByFilename(String filename) throws CheckstyleException {
        URI uri;
        try {
            URL url = new URL(filename);
            uri = url.toURI();
        }
        catch (MalformedURLException | URISyntaxException ignored) {
            uri = null;
        }
        if (uri == null) {
            File file = new File(filename);
            if (file.exists()) {
                uri = file.toURI();
            } else {
                try {
                    URL configUrl = CommonUtils.class.getResource(filename);
                    if (configUrl == null) {
                        throw new CheckstyleException(UNABLE_TO_FIND_EXCEPTION_PREFIX + filename);
                    }
                    uri = configUrl.toURI();
                }
                catch (URISyntaxException e) {
                    throw new CheckstyleException(UNABLE_TO_FIND_EXCEPTION_PREFIX + filename, e);
                }
            }
        }
        return uri;
    }
}

