/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.whitespace.PadOption;

public class EmptyForIteratorPadCheck
extends AbstractOptionCheck<PadOption> {
    public static final String WS_FOLLOWED = "ws.followed";
    public static final String WS_NOT_FOLLOWED = "ws.notFollowed";

    public EmptyForIteratorPadCheck() {
        super(PadOption.NOSPACE, PadOption.class);
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{37};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getChildCount() == 0) {
            DetailAST semi = ast.getPreviousSibling();
            String line = this.getLines()[semi.getLineNo() - 1];
            int after = semi.getColumnNo() + 1;
            if (after < line.length()) {
                if (this.getAbstractOption() == PadOption.NOSPACE && Character.isWhitespace(line.charAt(after))) {
                    this.log(semi.getLineNo(), after, WS_FOLLOWED, ";");
                } else if (this.getAbstractOption() == PadOption.SPACE && !Character.isWhitespace(line.charAt(after))) {
                    this.log(semi.getLineNo(), after, WS_NOT_FOLLOWED, ";");
                }
            }
        }
    }
}

