/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import org.geotools.referencing.factory.URI_Parser;
import org.geotools.referencing.factory.URI_Type;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Version;
import org.opengis.referencing.NoSuchAuthorityCodeException;

final class URN_Parser
extends URI_Parser {
    private static final String[] URN_BASES = new String[]{"urn:ogc:def:", "urn:x-ogc:def:"};
    private static final char URN_SEPARATOR = ':';

    protected URN_Parser(String urn, URI_Type type, String authority, Version version2, String code) {
        super(urn, type, authority, version2, code);
    }

    public static URN_Parser buildParser(String urn) throws NoSuchAuthorityCodeException {
        String code = urn.trim();
        String type = urn;
        for (int i = 0; i < URN_BASES.length; ++i) {
            int nameEnd;
            URI_Type candidate;
            int typeEnd;
            String urnBase = URN_BASES[i];
            int typeStart = urnBase.length();
            if (!code.regionMatches(true, 0, urnBase, 0, typeStart) || (typeEnd = code.indexOf(58, typeStart)) < 0 || (candidate = URI_Type.get(type = code.substring(typeStart, typeEnd).trim())) == null || (nameEnd = code.indexOf(58, typeEnd + 1)) < 0) continue;
            int lastEnd = code.lastIndexOf(58);
            Version urnVersion = lastEnd <= nameEnd ? null : new Version(code.substring(nameEnd + 1, lastEnd));
            String urnAuthority = code.substring(typeEnd + 1, nameEnd).trim();
            String urnCode = code.substring(lastEnd + 1).trim();
            URI_Type urnType = candidate;
            return new URN_Parser(urn, urnType, urnAuthority, urnVersion, urnCode);
        }
        throw new NoSuchAuthorityCodeException(Errors.format(67, type), "urn:ogc:def", type);
    }
}

