/*
 * Decompiled with CFR 0.152.
 */
package jena.cmdline;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jena.cmdline.Arg;
import jena.cmdline.ArgHandler;

public class ArgDecl {
    boolean takesValue;
    Set<String> names = new HashSet<String>();
    boolean takesArg = false;
    List<ArgHandler> argHooks = new ArrayList<ArgHandler>();
    public static final boolean HasValue = true;
    public static final boolean NoValue = false;

    public ArgDecl(boolean hasValue) {
        this.takesValue = hasValue;
    }

    public ArgDecl(boolean hasValue, String name) {
        this(hasValue);
        this.addName(name);
    }

    public ArgDecl(boolean hasValue, String name, ArgHandler handler) {
        this(hasValue);
        this.addName(name);
        this.addHook(handler);
    }

    public ArgDecl(boolean hasValue, String name1, String name2) {
        this(hasValue);
        this.addName(name1);
        this.addName(name2);
    }

    public ArgDecl(boolean hasValue, String name1, String name2, ArgHandler handler) {
        this(hasValue);
        this.addName(name1);
        this.addName(name2);
        this.addHook(handler);
    }

    public ArgDecl(boolean hasValue, String name1, String name2, String name3) {
        this(hasValue);
        this.addName(name1);
        this.addName(name2);
        this.addName(name3);
    }

    public ArgDecl(boolean hasValue, String name1, String name2, String name3, ArgHandler handler) {
        this(hasValue);
        this.addName(name1);
        this.addName(name2);
        this.addName(name3);
        this.addHook(handler);
    }

    public ArgDecl(boolean hasValue, String name1, String name2, String name3, String name4) {
        this(hasValue);
        this.addName(name1);
        this.addName(name2);
        this.addName(name3);
        this.addName(name4);
    }

    public ArgDecl(boolean hasValue, String name1, String name2, String name3, String name4, ArgHandler handler) {
        this(hasValue);
        this.addName(name1);
        this.addName(name2);
        this.addName(name3);
        this.addName(name4);
        this.addHook(handler);
    }

    public ArgDecl(boolean hasValue, String name1, String name2, String name3, String name4, String name5, ArgHandler handler) {
        this(hasValue);
        this.addName(name1);
        this.addName(name2);
        this.addName(name3);
        this.addName(name4);
        this.addName(name5);
        this.addHook(handler);
    }

    public void addName(String name) {
        name = ArgDecl.canonicalForm(name);
        this.names.add(name);
    }

    public Set<String> getNames() {
        return this.names;
    }

    public Iterator<String> names() {
        return this.names.iterator();
    }

    public void addHook(ArgHandler argHandler) {
        this.argHooks.add(argHandler);
    }

    protected void trigger(Arg arg) {
        for (ArgHandler handler : this.argHooks) {
            handler.action(arg.getName(), arg.getValue());
        }
    }

    public boolean takesValue() {
        return this.takesValue;
    }

    public boolean matches(Arg a) {
        for (String n : this.names) {
            if (!a.getName().equals(n)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(String arg) {
        arg = ArgDecl.canonicalForm(arg);
        return this.names.contains(arg);
    }

    static String canonicalForm(String str) {
        if (str.startsWith("--")) {
            return str.substring(2);
        }
        if (str.startsWith("-")) {
            return str.substring(1);
        }
        return str;
    }
}

