/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.parsers;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Ontology {
    private OntModel ontologyModel;
    private List<OntClass> listHierarchy;
    private static final int additiveID = 1373;
    private Map<String, List<String>> indirectClasses;
    private final Map<String, Integer> indirectClassesIDs;
    private final InputStream owlFile;

    public Ontology(InputStream owlFile) {
        this.owlFile = owlFile;
        this.indirectClassesIDs = new HashMap<String, Integer>();
        this.indirectClasses = new HashMap<String, List<String>>();
        this.listHierarchy = new ArrayList<OntClass>();
    }

    public void parseOntology() {
        try {
            this.ontologyModel = ModelFactory.createOntologyModel();
            Logger.getRootLogger().setLevel(Level.ERROR);
            this.ontologyModel.read(this.owlFile, null);
            Logger.getRootLogger().setLevel(Level.INFO);
            this.listHierarchy = this.ontologyModel.listHierarchyRootClasses().toList();
            this.setListHierarchy(this.listHierarchy);
            ExtendedIterator<OntClass> classes = this.ontologyModel.listClasses();
            while (classes.hasNext()) {
                OntClass obj = (OntClass)classes.next();
                if (!obj.hasSubClass()) continue;
                ExtendedIterator<OntClass> i = obj.listSubClasses(true);
                while (i.hasNext()) {
                    OntClass currentClass = (OntClass)i.next();
                    List<OntClass> superClasses = currentClass.listSuperClasses().toList();
                    ArrayList<String> superClassesStrings = new ArrayList<String>();
                    for (OntClass superClass : superClasses) {
                        String className = superClass.toString().replace("http://linkedgeodata.org/ontology/", "");
                        superClassesStrings.add(className);
                    }
                    this.indirectClasses.put(currentClass.getLocalName(), superClassesStrings);
                }
            }
            this.createIndirectClassesWithIDs();
            this.setIndirectClasses(this.indirectClasses);
            this.setOntologyModel(this.ontologyModel);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    private void createIndirectClassesWithIDs() {
        for (int i = 0; i < this.listHierarchy.size(); ++i) {
            String key = this.listHierarchy.get(i).toString().replace("http://linkedgeodata.org/ontology/", "");
            this.indirectClassesIDs.put(key, i + 1373);
        }
    }

    private void setOntologyModel(OntModel ontologyModel) {
        this.ontologyModel = ontologyModel;
    }

    private void setIndirectClasses(Map<String, List<String>> indirectClasses) {
        this.indirectClasses = indirectClasses;
    }

    private void setListHierarchy(List<OntClass> listHierarchy) {
        this.listHierarchy = listHierarchy;
    }

    public OntModel getOntologyModel() {
        return this.ontologyModel;
    }

    public Map<String, List<String>> getIndirectClasses() {
        return this.indirectClasses;
    }

    public List<OntClass> getListHierarchy() {
        return this.listHierarchy;
    }

    public Map<String, Integer> getIndirectClassesIDs() {
        return this.indirectClassesIDs;
    }
}

