/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.google.common.collect.ImmutableSortedSet;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.javadoc.HtmlTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.checks.javadoc.TagParser;
import com.puppycrawl.tools.checkstyle.utils.CheckUtils;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;

public class JavadocStyleCheck
extends Check {
    public static final String JAVADOC_MISSING = "javadoc.missing";
    public static final String EMPTY = "javadoc.empty";
    public static final String NO_PERIOD = "javadoc.noPeriod";
    public static final String INCOMPLETE_TAG = "javadoc.incompleteTag";
    public static final String UNCLOSED_HTML = "javadoc.unclosedHtml";
    public static final String EXTRA_HTML = "javadoc.extraHtml";
    private static final Set<String> SINGLE_TAGS = ImmutableSortedSet.of((Comparable)((Object)"br"), (Comparable)((Object)"li"), (Comparable)((Object)"dt"), (Comparable)((Object)"dd"), (Comparable)((Object)"hr"), (Comparable)((Object)"img"), (Comparable[])new String[]{"p", "td", "tr", "th"});
    private static final Set<String> ALLOWED_TAGS = ImmutableSortedSet.of((Comparable)((Object)"a"), (Comparable)((Object)"abbr"), (Comparable)((Object)"acronym"), (Comparable)((Object)"address"), (Comparable)((Object)"area"), (Comparable)((Object)"b"), (Comparable[])new String[]{"bdo", "big", "blockquote", "br", "caption", "cite", "code", "colgroup", "dd", "del", "div", "dfn", "dl", "dt", "em", "fieldset", "font", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "img", "ins", "kbd", "li", "ol", "p", "pre", "q", "samp", "small", "span", "strong", "style", "sub", "sup", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "tt", "u", "ul"});
    private Scope scope = Scope.PRIVATE;
    private Scope excludeScope;
    private String endOfSentenceFormat = "([.?!][ \t\n\r\f<])|([.?!]$)";
    private Pattern endOfSentencePattern;
    private boolean checkFirstSentence = true;
    private boolean checkHtml = true;
    private boolean checkEmptyJavadoc;

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{15, 14, 157, 154, 9, 8, 10, 155, 161, 16};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (this.shouldCheck(ast)) {
            FileContents contents = this.getFileContents();
            TextBlock cmt = contents.getJavadocBefore(ast.getFirstChild().getLineNo());
            this.checkComment(ast, cmt);
        }
    }

    private boolean shouldCheck(DetailAST ast) {
        boolean check = false;
        if (ast.getType() == 16) {
            check = this.getFileContents().inPackageInfo();
        } else if (!ScopeUtils.isInCodeBlock(ast)) {
            Scope customScope = ScopeUtils.isInInterfaceOrAnnotationBlock(ast) || ast.getType() == 155 ? Scope.PUBLIC : ScopeUtils.getScopeFromMods(ast.findFirstToken(5));
            Scope surroundingScope = ScopeUtils.getSurroundingScope(ast);
            check = customScope.isIn(this.scope) && (surroundingScope == null || surroundingScope.isIn(this.scope)) && (this.excludeScope == null || !customScope.isIn(this.excludeScope) || surroundingScope != null && !surroundingScope.isIn(this.excludeScope));
        }
        return check;
    }

    private void checkComment(DetailAST ast, TextBlock comment) {
        if (comment == null) {
            if (this.getFileContents().inPackageInfo()) {
                this.log(ast.getLineNo(), JAVADOC_MISSING, new Object[0]);
            }
            return;
        }
        if (this.checkFirstSentence) {
            this.checkFirstSentenceEnding(ast, comment);
        }
        if (this.checkHtml) {
            this.checkHtmlTags(ast, comment);
        }
        if (this.checkEmptyJavadoc) {
            this.checkJavadocIsNotEmpty(comment);
        }
    }

    private void checkFirstSentenceEnding(DetailAST ast, TextBlock comment) {
        String commentText = JavadocStyleCheck.getCommentText(comment.getText());
        if (!(commentText.isEmpty() || this.getEndOfSentencePattern().matcher(commentText).find() || "{@inheritDoc}".equals(commentText) && JavadocTagInfo.INHERIT_DOC.isValidOn(ast))) {
            this.log(comment.getStartLineNo(), NO_PERIOD, new Object[0]);
        }
    }

    private void checkJavadocIsNotEmpty(TextBlock comment) {
        String commentText = JavadocStyleCheck.getCommentText(comment.getText());
        if (commentText.isEmpty()) {
            this.log(comment.getStartLineNo(), EMPTY, new Object[0]);
        }
    }

    private static String getCommentText(String ... comments) {
        StringBuilder builder = new StringBuilder();
        for (String line : comments) {
            int textStart = JavadocStyleCheck.findTextStart(line);
            if (textStart == -1) continue;
            if (line.charAt(textStart) == '@') break;
            builder.append(line.substring(textStart));
            JavadocStyleCheck.trimTail(builder);
            builder.append('\n');
        }
        return builder.toString().trim();
    }

    private static int findTextStart(String line) {
        int textStart = -1;
        for (int i = 0; i < line.length(); ++i) {
            if (Character.isWhitespace(line.charAt(i))) continue;
            if (line.regionMatches(i, "/**", 0, "/**".length())) {
                i += 2;
                continue;
            }
            if (line.regionMatches(i, "*/", 0, 2)) {
                ++i;
                continue;
            }
            if (line.charAt(i) == '*') continue;
            textStart = i;
            break;
        }
        return textStart;
    }

    private static void trimTail(StringBuilder builder) {
        int i = builder.length() - 1;
        while (true) {
            if (Character.isWhitespace(builder.charAt(i))) {
                builder.deleteCharAt(i);
            } else {
                if (builder.charAt(i - 1) != '*') break;
                builder.deleteCharAt(i);
                builder.deleteCharAt(i - 1);
                --i;
                while (builder.charAt(i - 1) == '*') {
                    builder.deleteCharAt(i - 1);
                    --i;
                }
            }
            --i;
        }
    }

    private void checkHtmlTags(DetailAST ast, TextBlock comment) {
        int lineno = comment.getStartLineNo();
        ArrayDeque<HtmlTag> htmlStack = new ArrayDeque<HtmlTag>();
        String[] text = comment.getText();
        TagParser parser = new TagParser(text, lineno);
        while (parser.hasNextTag()) {
            HtmlTag tag = parser.nextTag();
            if (tag.isIncompleteTag()) {
                this.log(tag.getLineNo(), INCOMPLETE_TAG, text[tag.getLineNo() - lineno]);
                return;
            }
            if (tag.isClosedTag()) continue;
            if (tag.isCloseTag()) {
                if (JavadocStyleCheck.isExtraHtml(tag.getId(), htmlStack)) {
                    this.log(tag.getLineNo(), tag.getPosition(), EXTRA_HTML, tag);
                    continue;
                }
                this.checkUnclosedTags(htmlStack, tag.getId());
                continue;
            }
            if (!JavadocStyleCheck.isAllowedTag(tag)) continue;
            htmlStack.push(tag);
        }
        String lastFound = "";
        List<String> typeParameters = CheckUtils.getTypeParameterNames(ast);
        for (HtmlTag htag : htmlStack) {
            if (JavadocStyleCheck.isSingleTag(htag) || htag.getId().equals(lastFound) || typeParameters.contains(htag.getId())) continue;
            this.log(htag.getLineNo(), htag.getPosition(), UNCLOSED_HTML, htag);
            lastFound = htag.getId();
        }
    }

    private void checkUnclosedTags(Deque<HtmlTag> htmlStack, String token) {
        ArrayDeque<HtmlTag> unclosedTags = new ArrayDeque<HtmlTag>();
        HtmlTag lastOpenTag = htmlStack.pop();
        while (!token.equalsIgnoreCase(lastOpenTag.getId())) {
            if (JavadocStyleCheck.isSingleTag(lastOpenTag)) {
                lastOpenTag = htmlStack.pop();
                continue;
            }
            unclosedTags.push(lastOpenTag);
            lastOpenTag = htmlStack.pop();
        }
        String lastFound = "";
        for (HtmlTag htag : unclosedTags) {
            lastOpenTag = htag;
            if (lastOpenTag.getId().equals(lastFound)) continue;
            lastFound = lastOpenTag.getId();
            this.log(lastOpenTag.getLineNo(), lastOpenTag.getPosition(), UNCLOSED_HTML, lastOpenTag);
        }
    }

    private static boolean isSingleTag(HtmlTag tag) {
        return SINGLE_TAGS.contains(tag.getId().toLowerCase(Locale.ENGLISH));
    }

    private static boolean isAllowedTag(HtmlTag tag) {
        return ALLOWED_TAGS.contains(tag.getId().toLowerCase(Locale.ENGLISH));
    }

    private static boolean isExtraHtml(String token, Deque<HtmlTag> htmlStack) {
        boolean isExtra = true;
        for (HtmlTag td : htmlStack) {
            if (!token.equalsIgnoreCase(td.getId())) continue;
            isExtra = false;
            break;
        }
        return isExtra;
    }

    public void setScope(String from) {
        this.scope = Scope.getInstance(from);
    }

    public void setExcludeScope(String excludeScope) {
        this.excludeScope = Scope.getInstance(excludeScope);
    }

    public void setEndOfSentenceFormat(String format) {
        this.endOfSentenceFormat = format;
    }

    private Pattern getEndOfSentencePattern() {
        if (this.endOfSentencePattern == null) {
            this.endOfSentencePattern = Pattern.compile(this.endOfSentenceFormat);
        }
        return this.endOfSentencePattern;
    }

    public void setCheckFirstSentence(boolean flag) {
        this.checkFirstSentence = flag;
    }

    public void setCheckHtml(boolean flag) {
        this.checkHtml = flag;
    }

    public void setCheckEmptyJavadoc(boolean flag) {
        this.checkEmptyJavadoc = flag;
    }
}

