/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.BlockParentHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.checks.indentation.LineWrappingHandler;

public class SynchronizedHandler
extends BlockParentHandler {
    private final boolean methodModifier;

    public SynchronizedHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, "synchronized", ast, parent);
        this.methodModifier = SynchronizedHandler.isMethodModifier(ast);
    }

    @Override
    public void checkIndentation() {
        if (!this.methodModifier) {
            super.checkIndentation();
            this.checkSynchronizedExpr();
            LineWrappingHandler lineWrap = new LineWrappingHandler(this.getIndentCheck(), this.getMainAst(), SynchronizedHandler.getSynchronizedStatementRightParen(this.getMainAst()));
            lineWrap.checkIndentation();
        }
    }

    private void checkSynchronizedExpr() {
        DetailAST syncAst = this.getMainAst().findFirstToken(76).getNextSibling();
        IndentLevel expected = new IndentLevel(this.getLevel(), this.getBasicOffset());
        this.checkExpressionSubtree(syncAst, expected, false, false);
    }

    private static boolean isMethodModifier(DetailAST ast) {
        return ast.getParent().getType() == 5;
    }

    private static DetailAST getSynchronizedStatementRightParen(DetailAST syncStatementAST) {
        return syncStatementAST.findFirstToken(77);
    }
}

